/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsTooltip;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.core.localization.GuiText;
import appeng.crafting.pattern.PatternNbtUtils;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AESmithingTablePattern
implements IPatternDetails,
IMolecularAssemblerSupportedPattern {
    private static final String NBT_TEMPLATE = "template";
    private static final String NBT_BASE = "base";
    private static final String NBT_ADDITION = "addition";
    private static final String NBT_OUTPUT = "out";
    private static final String NBT_SUBSITUTE = "substitute";
    private static final String NBT_RECIPE_ID = "recipe";
    private static final int TEMPLATE_CRAFTING_GRID_SLOT = 3;
    private static final int BASE_CRAFTING_GRID_SLOT = 4;
    private static final int ADDITION_CRAFTING_GRID_SLOT = 5;
    private final AEItemKey definition;
    public final boolean canSubstitute;
    private final ResourceLocation recipeId;
    private final SmithingRecipe recipe;
    private final Container testFrame;
    private final ItemStack output;
    private final AEItemKey template;
    private final AEItemKey base;
    private final AEItemKey addition;
    private final IPatternDetails.IInput[] inputs;
    private final GenericStack[] outputs;

    public AESmithingTablePattern(AEItemKey definition, Level level) {
        Ingredient additionIngredient;
        Ingredient baseIngredient;
        Ingredient templateIngredient;
        this.definition = definition;
        CompoundTag tag = Objects.requireNonNull(definition.getTag());
        this.template = PatternNbtUtils.getRequiredItemKey(tag, NBT_TEMPLATE);
        this.base = PatternNbtUtils.getRequiredItemKey(tag, NBT_BASE);
        this.addition = PatternNbtUtils.getRequiredItemKey(tag, NBT_ADDITION);
        this.canSubstitute = PatternNbtUtils.getBoolean(tag, NBT_SUBSITUTE, false);
        this.recipeId = PatternNbtUtils.getRequiredResourceLocation(tag, NBT_RECIPE_ID);
        this.recipe = (SmithingRecipe)((RecipeHolder)level.getRecipeManager().byType(RecipeType.SMITHING).get(this.recipeId)).value();
        this.testFrame = new SimpleContainer(3);
        this.testFrame.setItem(0, this.template.toStack());
        this.testFrame.setItem(1, this.base.toStack());
        this.testFrame.setItem(2, this.addition.toStack());
        if (!this.recipe.matches(this.testFrame, level)) {
            throw new IllegalStateException("The recipe " + this.recipeId + " no longer matches the encoded input.");
        }
        this.output = this.recipe.assemble(this.testFrame, level.registryAccess());
        if (this.output.isEmpty()) {
            throw new IllegalStateException("The recipe " + this.recipeId + " produced an empty item stack result.");
        }
        SmithingRecipe smithingRecipe = this.recipe;
        if (smithingRecipe instanceof SmithingTransformRecipe) {
            SmithingTransformRecipe r = (SmithingTransformRecipe)smithingRecipe;
            templateIngredient = r.template;
            baseIngredient = r.base;
            additionIngredient = r.addition;
        } else {
            smithingRecipe = this.recipe;
            if (smithingRecipe instanceof SmithingTrimRecipe) {
                SmithingTrimRecipe r = (SmithingTrimRecipe)smithingRecipe;
                templateIngredient = r.template;
                baseIngredient = r.base;
                additionIngredient = r.addition;
            } else {
                throw new IllegalStateException("Don't know how to process non-vanilla smithing recipe: " + this.recipe.getClass());
            }
        }
        this.inputs = new IPatternDetails.IInput[]{new Input(this.template, templateIngredient, 3), new Input(this.base, baseIngredient, 4), new Input(this.addition, additionIngredient, 5)};
        this.outputs = new GenericStack[]{GenericStack.fromItemStack(this.output)};
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((AESmithingTablePattern)obj).definition.equals(this.definition);
    }

    @Override
    public AEItemKey getDefinition() {
        return this.definition;
    }

    public AEItemKey getTemplate() {
        return this.template;
    }

    public AEItemKey getBase() {
        return this.base;
    }

    public AEItemKey getAddition() {
        return this.addition;
    }

    @Override
    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    @Override
    public GenericStack[] getOutputs() {
        return this.outputs;
    }

    public boolean canSubstitute() {
        return this.canSubstitute;
    }

    @Override
    public ItemStack assemble(Container container, Level level) {
        SimpleContainer testContainer = new SimpleContainer(3);
        testContainer.setItem(0, container.getItem(3));
        testContainer.setItem(1, container.getItem(4));
        testContainer.setItem(2, container.getItem(5));
        if (this.recipe.matches((Container)testContainer, level)) {
            return this.recipe.assemble((Container)testContainer, level.registryAccess());
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean isItemValid(int gridSlot, AEItemKey key, Level level) {
        int containerSlot;
        if (key == null) {
            return false;
        }
        if (!this.canSubstitute) {
            if (gridSlot == 3) {
                return this.template.equals(key);
            }
            if (gridSlot == 4) {
                return this.base.equals(key);
            }
            if (gridSlot == 5) {
                return this.addition.equals(key);
            }
            return false;
        }
        if (gridSlot == 3) {
            containerSlot = 0;
        } else if (gridSlot == 4) {
            containerSlot = 1;
        } else if (gridSlot == 5) {
            containerSlot = 2;
        } else {
            return false;
        }
        ItemStack previousStack = this.testFrame.removeItemNoUpdate(containerSlot);
        this.testFrame.setItem(containerSlot, key.toStack());
        boolean newResult = this.recipe.matches(this.testFrame, level) && ItemStack.matches((ItemStack)this.output, (ItemStack)this.recipe.assemble(this.testFrame, level.registryAccess()));
        this.testFrame.setItem(containerSlot, previousStack);
        return newResult;
    }

    @Override
    public boolean isSlotEnabled(int slot) {
        return slot == 3 || slot == 4 || slot == 5;
    }

    @Override
    public void fillCraftingGrid(KeyCounter[] table, IMolecularAssemblerSupportedPattern.CraftingGridAccessor gridAccessor) {
        AEItemKey itemKey;
        Object object;
        Object2LongMap.Entry<AEKey> entry = table[0].getFirstEntry();
        if (entry != null && (object = entry.getKey()) instanceof AEItemKey) {
            itemKey = (AEItemKey)object;
            gridAccessor.set(3, itemKey.toStack());
            table[0].remove((AEKey)entry.getKey(), 1L);
        }
        if ((entry = table[1].getFirstEntry()) != null && (object = entry.getKey()) instanceof AEItemKey) {
            itemKey = (AEItemKey)object;
            gridAccessor.set(4, itemKey.toStack());
            table[1].remove((AEKey)entry.getKey(), 1L);
        }
        if ((entry = table[2].getFirstEntry()) != null && (object = entry.getKey()) instanceof AEItemKey) {
            itemKey = (AEItemKey)object;
            gridAccessor.set(5, itemKey.toStack());
            table[2].remove((AEKey)entry.getKey(), 1L);
        }
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        return NonNullList.withSize((int)container.getContainerSize(), (Object)ItemStack.EMPTY);
    }

    public static void encode(CompoundTag tag, RecipeHolder<SmithingRecipe> recipe, AEItemKey template, AEItemKey base, AEItemKey addition, AEItemKey output, boolean allowSubstitutes) {
        Preconditions.checkNotNull(recipe, (Object)NBT_RECIPE_ID);
        Preconditions.checkNotNull(recipe, (Object)NBT_TEMPLATE);
        Preconditions.checkNotNull((Object)base, (Object)NBT_BASE);
        Preconditions.checkNotNull((Object)addition, (Object)NBT_ADDITION);
        Preconditions.checkNotNull((Object)output, (Object)"output");
        tag.put(NBT_TEMPLATE, (Tag)template.toTag());
        tag.put(NBT_BASE, (Tag)base.toTag());
        tag.put(NBT_ADDITION, (Tag)addition.toTag());
        tag.put(NBT_OUTPUT, (Tag)output.toTag());
        tag.putBoolean(NBT_SUBSITUTE, allowSubstitutes);
        tag.putString(NBT_RECIPE_ID, recipe.id().toString());
    }

    @Override
    public PatternDetailsTooltip getTooltip(Level level, TooltipFlag flags) {
        PatternDetailsTooltip tooltip = new PatternDetailsTooltip(PatternDetailsTooltip.OUTPUT_TEXT_CRAFTS);
        tooltip.addInputsAndOutputs(this);
        if (flags.isAdvanced()) {
            tooltip.addProperty((Component)Component.literal((String)"Recipe"), (Component)Component.literal((String)this.recipeId.toString()));
        }
        return tooltip;
    }

    public static PatternDetailsTooltip getInvalidTooltip(CompoundTag tag, Level level, @Nullable Exception cause, TooltipFlag flags) {
        PatternDetailsTooltip tooltip = new PatternDetailsTooltip(PatternDetailsTooltip.OUTPUT_TEXT_CRAFTS);
        PatternNbtUtils.readKeyFaultTolerant(tag, NBT_TEMPLATE).ifPresent(tooltip::addInput);
        PatternNbtUtils.readKeyFaultTolerant(tag, NBT_BASE).ifPresent(tooltip::addInput);
        PatternNbtUtils.readKeyFaultTolerant(tag, NBT_ADDITION).ifPresent(tooltip::addInput);
        PatternNbtUtils.readKeyFaultTolerant(tag, NBT_OUTPUT).ifPresent(tooltip::addOutput);
        if (PatternNbtUtils.getBoolean(tag, NBT_SUBSITUTE, false)) {
            tooltip.addProperty((Component)GuiText.PatternTooltipSubstitutions.text());
        }
        if (flags.isAdvanced()) {
            PatternNbtUtils.tryGetString(tag, NBT_RECIPE_ID).ifPresent(recipeId -> tooltip.addProperty((Component)Component.literal((String)"Recipe"), (Component)Component.literal((String)recipeId)));
        }
        return tooltip;
    }

    private class Input
    implements IPatternDetails.IInput {
        private final GenericStack[] possibleInputs;
        private final int gridSlot;

        private Input(AEItemKey what, Ingredient recipeIngredient, int gridSlot) {
            this.gridSlot = gridSlot;
            if (!AESmithingTablePattern.this.canSubstitute) {
                this.possibleInputs = new GenericStack[]{new GenericStack(what, 1L)};
            } else {
                ItemStack[] matchingStacks = recipeIngredient.getItems();
                this.possibleInputs = new GenericStack[matchingStacks.length + 1];
                this.possibleInputs[0] = new GenericStack(what, 1L);
                for (int i = 0; i < matchingStacks.length; ++i) {
                    this.possibleInputs[i + 1] = GenericStack.fromItemStack(matchingStacks[i]);
                }
            }
        }

        @Override
        public GenericStack[] getPossibleInputs() {
            return this.possibleInputs;
        }

        @Override
        public long getMultiplier() {
            return 1L;
        }

        @Override
        public boolean isValid(AEKey input, Level level) {
            if (input.matches(this.possibleInputs[0])) {
                return true;
            }
            if (AESmithingTablePattern.this.canSubstitute() && input instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)input;
                return AESmithingTablePattern.this.isItemValid(this.gridSlot, itemKey, level);
            }
            return false;
        }

        @Override
        @Nullable
        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

