/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsTooltip;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.core.localization.GuiText;
import appeng.crafting.pattern.PatternNbtUtils;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AEStonecuttingPattern
implements IPatternDetails,
IMolecularAssemblerSupportedPattern {
    private static final String NBT_INPUT = "in";
    private static final String NBT_OUTPUT = "out";
    private static final String NBT_SUBSITUTE = "substitute";
    private static final String NBT_RECIPE_ID = "recipe";
    private static final int CRAFTING_GRID_SLOT = 4;
    private final AEItemKey definition;
    public final boolean canSubstitute;
    private final ResourceLocation recipeId;
    private final StonecutterRecipe recipe;
    private final Container testFrame;
    private final AEItemKey input;
    private final ItemStack output;
    private final IPatternDetails.IInput[] inputs;
    private final GenericStack[] outputs;
    private final Map<Item, Boolean> isValidCache = new IdentityHashMap<Item, Boolean>();

    public AEStonecuttingPattern(AEItemKey definition, Level level) {
        this.definition = definition;
        CompoundTag tag = Objects.requireNonNull(definition.getTag());
        this.input = PatternNbtUtils.getRequiredItemKey(tag, NBT_INPUT);
        this.canSubstitute = PatternNbtUtils.getBoolean(tag, NBT_SUBSITUTE, false);
        this.recipeId = AEStonecuttingPattern.getRecipeId(tag);
        this.recipe = (StonecutterRecipe)((RecipeHolder)level.getRecipeManager().byType(RecipeType.STONECUTTING).get(this.recipeId)).value();
        this.testFrame = new SimpleContainer(1);
        this.testFrame.setItem(0, this.input.toStack());
        if (!this.recipe.matches(this.testFrame, level)) {
            throw new IllegalStateException("The recipe " + this.recipeId + " no longer matches the encoded input.");
        }
        this.output = this.recipe.assemble(this.testFrame, level.registryAccess());
        if (this.output.isEmpty()) {
            throw new IllegalStateException("The recipe " + this.recipeId + " produced an empty item stack result.");
        }
        this.inputs = new IPatternDetails.IInput[]{new Input()};
        this.outputs = new GenericStack[]{GenericStack.fromItemStack(this.output)};
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((AEStonecuttingPattern)obj).definition.equals(this.definition);
    }

    @Override
    public AEItemKey getDefinition() {
        return this.definition;
    }

    @Override
    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    @Override
    public GenericStack[] getOutputs() {
        return this.outputs;
    }

    @Override
    public PatternDetailsTooltip getTooltip(Level level, TooltipFlag flags) {
        PatternDetailsTooltip tooltip = new PatternDetailsTooltip(PatternDetailsTooltip.OUTPUT_TEXT_CRAFTS);
        tooltip.addInputsAndOutputs(this);
        if (flags.isAdvanced()) {
            tooltip.addProperty((Component)Component.literal((String)"Recipe"), (Component)Component.literal((String)this.recipeId.toString()));
        }
        return tooltip;
    }

    public static PatternDetailsTooltip getInvalidTooltip(CompoundTag tag, Level level, @Nullable Exception cause, TooltipFlag flags) {
        PatternDetailsTooltip tooltip = new PatternDetailsTooltip(PatternDetailsTooltip.OUTPUT_TEXT_CRAFTS);
        PatternNbtUtils.readKeyFaultTolerant(tag, NBT_INPUT).ifPresent(tooltip::addInput);
        PatternNbtUtils.readKeyFaultTolerant(tag, NBT_OUTPUT).ifPresent(tooltip::addOutput);
        if (PatternNbtUtils.getBoolean(tag, NBT_SUBSITUTE, false)) {
            tooltip.addProperty((Component)GuiText.PatternTooltipSubstitutions.text());
        }
        if (flags.isAdvanced()) {
            PatternNbtUtils.tryGetString(tag, NBT_RECIPE_ID).ifPresent(recipeId -> tooltip.addProperty((Component)Component.literal((String)"Recipe"), (Component)Component.literal((String)recipeId)));
        }
        return tooltip;
    }

    private Ingredient getRecipeIngredient() {
        return (Ingredient)this.recipe.getIngredients().get(0);
    }

    public boolean isItemValid(AEItemKey key, Level level) {
        if (key == null) {
            return false;
        }
        if (!this.canSubstitute) {
            return this.input.equals(key);
        }
        Boolean result = this.getTestResult(key);
        if (result != null) {
            return result;
        }
        ItemStack previousStack = this.testFrame.removeItemNoUpdate(0);
        this.testFrame.setItem(0, key.toStack());
        boolean newResult = this.recipe.matches(this.testFrame, level) && ItemStack.matches((ItemStack)this.output, (ItemStack)this.recipe.assemble(this.testFrame, level.registryAccess()));
        this.setTestResult(key, newResult);
        this.testFrame.setItem(0, previousStack);
        return newResult;
    }

    @Nullable
    private Boolean getTestResult(AEItemKey what) {
        if (what == null || what.hasTag()) {
            return null;
        }
        return this.isValidCache.get(what.getItem());
    }

    private void setTestResult(AEItemKey what, boolean result) {
        if (what != null && !what.hasTag()) {
            this.isValidCache.put(what.getItem(), result);
        }
    }

    public boolean canSubstitute() {
        return this.canSubstitute;
    }

    @Override
    public ItemStack assemble(Container container, Level level) {
        SimpleContainer testContainer = new SimpleContainer(2);
        testContainer.setItem(0, container.getItem(4));
        if (this.recipe.matches((Container)testContainer, level)) {
            return this.recipe.assemble((Container)testContainer, level.registryAccess());
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean isItemValid(int slot, AEItemKey key, Level level) {
        return slot == 4 && this.isItemValid(key, level);
    }

    @Override
    public boolean isSlotEnabled(int slot) {
        return slot == 4;
    }

    @Override
    public void fillCraftingGrid(KeyCounter[] table, IMolecularAssemblerSupportedPattern.CraftingGridAccessor gridAccessor) {
        Object object;
        Object2LongMap.Entry<AEKey> entry = table[0].getFirstEntry();
        if (entry != null && (object = entry.getKey()) instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)object;
            gridAccessor.set(4, itemKey.toStack());
            table[0].remove((AEKey)entry.getKey(), 1L);
        }
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        return NonNullList.withSize((int)container.getContainerSize(), (Object)ItemStack.EMPTY);
    }

    public AEItemKey getInput() {
        return this.input;
    }

    public static void encode(CompoundTag tag, RecipeHolder<StonecutterRecipe> recipe, AEItemKey input, AEItemKey output, boolean allowSubstitution) {
        Preconditions.checkNotNull(recipe, (Object)NBT_RECIPE_ID);
        Preconditions.checkNotNull((Object)input, (Object)"input");
        Preconditions.checkNotNull((Object)output, (Object)"output");
        tag.put(NBT_INPUT, (Tag)input.toTag());
        tag.put(NBT_OUTPUT, (Tag)output.toTag());
        tag.putBoolean(NBT_SUBSITUTE, allowSubstitution);
        tag.putString(NBT_RECIPE_ID, recipe.id().toString());
    }

    public static ResourceLocation getRecipeId(CompoundTag nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return new ResourceLocation(nbt.getString(NBT_RECIPE_ID));
    }

    private class Input
    implements IPatternDetails.IInput {
        private final GenericStack[] possibleInputs;

        private Input() {
            if (!AEStonecuttingPattern.this.canSubstitute) {
                this.possibleInputs = new GenericStack[]{new GenericStack(AEStonecuttingPattern.this.input, 1L)};
            } else {
                ItemStack[] matchingStacks = AEStonecuttingPattern.this.getRecipeIngredient().getItems();
                this.possibleInputs = new GenericStack[matchingStacks.length + 1];
                this.possibleInputs[0] = new GenericStack(AEStonecuttingPattern.this.input, 1L);
                for (int i = 0; i < matchingStacks.length; ++i) {
                    this.possibleInputs[i + 1] = GenericStack.fromItemStack(matchingStacks[i]);
                }
            }
        }

        @Override
        public GenericStack[] getPossibleInputs() {
            return this.possibleInputs;
        }

        @Override
        public long getMultiplier() {
            return 1L;
        }

        @Override
        public boolean isValid(AEKey input, Level level) {
            if (input.matches(this.possibleInputs[0])) {
                return true;
            }
            if (AEStonecuttingPattern.this.canSubstitute() && input instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)input;
                return AEStonecuttingPattern.this.isItemValid(itemKey, level);
            }
            return false;
        }

        @Override
        @Nullable
        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

