/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.crafting.PatternDetailsTooltip;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.AEKeyTypes;
import appeng.api.stacks.GenericStack;
import com.google.common.base.Preconditions;
import com.machinezoo.noexception.optional.OptionalBoolean;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

final class PatternNbtUtils {
    private PatternNbtUtils() {
    }

    public static boolean getBoolean(@Nullable CompoundTag tag, String name, boolean defaultValue) {
        return PatternNbtUtils.tryGetBoolean(tag, name).orElse(defaultValue);
    }

    public static OptionalBoolean tryGetBoolean(@Nullable CompoundTag tag, String name) {
        if (tag != null && tag.contains(name, 1)) {
            return OptionalBoolean.of((boolean)tag.getBoolean(name));
        }
        return OptionalBoolean.empty();
    }

    public static ResourceLocation getRequiredResourceLocation(@Nullable CompoundTag tag, String name) {
        if (tag != null && tag.contains(name, 8)) {
            try {
                return new ResourceLocation(tag.getString(name));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to read required resource location " + name, e);
            }
        }
        throw new IllegalArgumentException("Tag is missing required resource location " + name);
    }

    public static Optional<ResourceLocation> tryGetResourceLocation(@Nullable CompoundTag tag, String name) {
        if (tag != null && tag.contains(name, 8)) {
            try {
                return Optional.of(new ResourceLocation(tag.getString(name)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static AEItemKey getRequiredItemKey(@Nullable CompoundTag tag, String name) {
        if (tag != null && tag.contains(name, 10)) {
            return AEItemKey.fromTag(tag.getCompound(name));
        }
        throw new IllegalArgumentException("Tag is missing required key " + name);
    }

    public static ListTag encodeItemStackList(ItemStack[] stacks) {
        ListTag tag = new ListTag();
        boolean foundStack = false;
        for (ItemStack stack : stacks) {
            if (stack.isEmpty()) {
                tag.add((Object)new CompoundTag());
                continue;
            }
            tag.add((Object)stack.save(new CompoundTag()));
            foundStack = true;
        }
        Preconditions.checkArgument((boolean)foundStack, (Object)"List passed to pattern must contain at least one stack.");
        return tag;
    }

    public static Optional<PatternDetailsTooltip.Entry> readItemStackFaultTolerant(@Nullable CompoundTag tag, String name) {
        if (tag != null) {
            return PatternNbtUtils.readItemStackFaultTolerant(tag.get(name));
        }
        return Optional.empty();
    }

    public static Optional<PatternDetailsTooltip.Entry> readItemStackFaultTolerant(@Nullable Tag tag) {
        if (!(tag instanceof CompoundTag)) {
            return Optional.empty();
        }
        CompoundTag compoundTag = (CompoundTag)tag;
        if (compoundTag.isEmpty()) {
            return Optional.empty();
        }
        GenericStack stack = GenericStack.fromItemStack(ItemStack.of((CompoundTag)compoundTag));
        if (stack != null) {
            return Optional.of(new PatternDetailsTooltip.ValidEntry(stack));
        }
        try {
            String id = compoundTag.getString("id");
            int count = compoundTag.getInt("Count");
            return Optional.of(new PatternDetailsTooltip.InvalidEntry((Component)Component.literal((String)id), AEKeyType.items(), count));
        }
        catch (Exception ignored) {
            return Optional.of(new PatternDetailsTooltip.InvalidEntry((Component)Component.literal((String)"Invalid Entry"), AEKeyType.items(), 1L));
        }
    }

    public static void readItemStackListFaultTolerant(@Nullable CompoundTag tag, String name, Consumer<PatternDetailsTooltip.Entry> entryConsumer) {
        if (tag == null || !tag.contains(name, 9)) {
            return;
        }
        ListTag list = (ListTag)tag.get(name);
        for (Tag child : list) {
            PatternNbtUtils.readItemStackFaultTolerant(child).ifPresent(entryConsumer);
        }
    }

    public static Optional<PatternDetailsTooltip.Entry> readKeyFaultTolerant(@Nullable CompoundTag tag, String name) {
        try {
            return Optional.of(new PatternDetailsTooltip.ValidEntry(PatternNbtUtils.getRequiredItemKey(tag, name), 1L));
        }
        catch (Exception exception) {
            CompoundTag keyTag;
            if (tag != null && tag.contains(name, 10) && (keyTag = tag.getCompound(name)).contains("id", 8)) {
                String id = keyTag.getString("id");
                return Optional.of(new PatternDetailsTooltip.InvalidEntry((Component)Component.literal((String)id), AEKeyType.items(), 1L));
            }
            return Optional.empty();
        }
    }

    public static GenericStack[] getRequiredGenericStackList(@Nullable CompoundTag tag, String name, int maxSize) {
        Objects.requireNonNull(tag, "Pattern must have a tag.");
        if (!tag.contains(name, 9)) {
            throw new IllegalArgumentException("Tag is missing required key " + name);
        }
        ListTag listTag = tag.getList(name, 10);
        if (listTag.size() > maxSize) {
            throw new IllegalArgumentException("Cannot use more than " + maxSize + " ingredients");
        }
        GenericStack[] result = new GenericStack[listTag.size()];
        for (int x = 0; x < listTag.size(); ++x) {
            CompoundTag entry = listTag.getCompound(x);
            if (entry.isEmpty()) continue;
            GenericStack stack = GenericStack.readTag(entry);
            if (stack == null) {
                throw new IllegalArgumentException("Pattern references missing stack: " + entry);
            }
            result[x] = stack;
        }
        return result;
    }

    public static Optional<PatternDetailsTooltip.Entry> readGenericStackFaultTolerant(@Nullable Tag tag) {
        CompoundTag compoundTag;
        if (!(tag instanceof CompoundTag) || (compoundTag = (CompoundTag)tag).isEmpty()) {
            return Optional.empty();
        }
        try {
            GenericStack stack = GenericStack.readTag(compoundTag);
            if (stack != null) {
                return Optional.of(new PatternDetailsTooltip.ValidEntry(stack));
            }
        }
        catch (Exception stack) {
            // empty catch block
        }
        long amount = 1L;
        if (compoundTag.contains("#", 4)) {
            amount = compoundTag.getLong("#");
        }
        String id = "Unknown";
        if (compoundTag.contains("id", 8)) {
            id = compoundTag.getString("id");
        }
        MutableComponent idString = Component.literal((String)id);
        AEKeyType keyType = null;
        if (compoundTag.contains("#c", 8)) {
            String keyTypeId = compoundTag.getString("#c");
            try {
                keyType = AEKeyTypes.get(new ResourceLocation(keyTypeId));
            }
            catch (Exception ignored) {
                idString.append(" (" + keyTypeId + ")");
            }
        }
        return Optional.of(new PatternDetailsTooltip.InvalidEntry((Component)idString, keyType, amount));
    }

    public static void getGenericStackListFaultTolerant(@Nullable CompoundTag tag, String name, Consumer<PatternDetailsTooltip.Entry> consumer) {
        if (tag == null || !tag.contains(name, 9)) {
            return;
        }
        ListTag listTag = (ListTag)tag.get(name);
        for (Tag child : listTag) {
            CompoundTag compoundChild;
            if (!(child instanceof CompoundTag) || (compoundChild = (CompoundTag)child).isEmpty()) continue;
            GenericStack stack = GenericStack.readTag(compoundChild);
            if (stack != null) {
                consumer.accept(new PatternDetailsTooltip.ValidEntry(stack));
                continue;
            }
            PatternNbtUtils.readGenericStackFaultTolerant(child).ifPresent(consumer);
        }
    }

    public static Optional<String> tryGetString(@Nullable CompoundTag tag, String name) {
        if (tag != null && tag.contains(name, 8)) {
            return Optional.of(tag.getString(name));
        }
        return Optional.empty();
    }
}

