/*
 * Decompiled with CFR 0.152.
 */
package appeng.entity;

import appeng.entity.TinyTNTPrimedEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.TntMinecartRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class TinyTNTPrimedRenderer
extends EntityRenderer<TinyTNTPrimedEntity> {
    private final BlockRenderDispatcher blockRenderer;

    public TinyTNTPrimedRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.25f;
        this.blockRenderer = context.getBlockRenderDispatcher();
    }

    public void render(TinyTNTPrimedEntity tnt, float entityYaw, float partialTicks, PoseStack mStack, MultiBufferSource buffers, int packedLight) {
        float f2;
        mStack.pushPose();
        mStack.translate(0.0f, 0.25f, 0.0f);
        if ((float)tnt.getFuse() - partialTicks + 1.0f < 10.0f) {
            f2 = 1.0f - ((float)tnt.getFuse() - partialTicks + 1.0f) / 10.0f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            f2 *= f2;
            f2 *= f2;
            float f3 = 1.0f + f2 * 0.3f;
            mStack.scale(f3, f3, f3);
        }
        mStack.scale(0.5f, 0.5f, 0.5f);
        f2 = (1.0f - ((float)tnt.getFuse() - partialTicks + 1.0f) / 100.0f) * 0.8f;
        mStack.mulPose(new Quaternionf().rotationY(-1.5707964f));
        mStack.translate(-0.5, -0.5, 0.5);
        mStack.mulPose(new Quaternionf().rotationY(1.5707964f));
        TntMinecartRenderer.renderWhiteSolidBlock((BlockRenderDispatcher)this.blockRenderer, (BlockState)Blocks.TNT.defaultBlockState(), (PoseStack)mStack, (MultiBufferSource)buffers, (int)packedLight, (tnt.getFuse() / 5 % 2 == 0 ? 1 : 0) != 0);
        mStack.popPose();
        super.render((Entity)tnt, entityYaw, partialTicks, mStack, buffers, packedLight);
    }

    public ResourceLocation getTextureLocation(TinyTNTPrimedEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

