/*
 * Decompiled with CFR 0.152.
 */
package appeng.init.client;

import appeng.blockentity.networking.CableBusTESR;
import appeng.client.render.crafting.CraftingMonitorRenderer;
import appeng.client.render.crafting.MolecularAssemblerRenderer;
import appeng.client.render.tesr.ChargerBlockEntityRenderer;
import appeng.client.render.tesr.ChestBlockEntityRenderer;
import appeng.client.render.tesr.CrankRenderer;
import appeng.client.render.tesr.DriveLedBlockEntityRenderer;
import appeng.client.render.tesr.InscriberTESR;
import appeng.client.render.tesr.SkyChestTESR;
import appeng.client.render.tesr.SkyStoneTankBlockEntityRenderer;
import appeng.core.definitions.AEBlockEntities;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class InitBlockEntityRenderers {
    private InitBlockEntityRenderers() {
    }

    public static void init() {
        InitBlockEntityRenderers.register(AEBlockEntities.CRANK, CrankRenderer::new);
        InitBlockEntityRenderers.register(AEBlockEntities.INSCRIBER, InscriberTESR::new);
        InitBlockEntityRenderers.register(AEBlockEntities.SKY_CHEST, SkyChestTESR::new);
        InitBlockEntityRenderers.register(AEBlockEntities.CHARGER, ChargerBlockEntityRenderer.FACTORY);
        InitBlockEntityRenderers.register(AEBlockEntities.DRIVE, DriveLedBlockEntityRenderer::new);
        InitBlockEntityRenderers.register(AEBlockEntities.CHEST, ChestBlockEntityRenderer::new);
        InitBlockEntityRenderers.register(AEBlockEntities.CRAFTING_MONITOR, CraftingMonitorRenderer::new);
        InitBlockEntityRenderers.register(AEBlockEntities.MOLECULAR_ASSEMBLER, MolecularAssemblerRenderer::new);
        InitBlockEntityRenderers.register(AEBlockEntities.CABLE_BUS, CableBusTESR::new);
        InitBlockEntityRenderers.register(AEBlockEntities.SKY_STONE_TANK, SkyStoneTankBlockEntityRenderer::new);
    }

    private static <T extends BlockEntity> void register(BlockEntityType<T> type, BlockEntityRendererProvider<T> factory) {
        BlockEntityRenderers.register(type, factory);
    }
}

