/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.emi;

import appeng.api.integrations.emi.EmiStackConverter;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

class EmiFluidStackConverter
implements EmiStackConverter {
    EmiFluidStackConverter() {
    }

    @Override
    public Class<?> getKeyType() {
        return Fluid.class;
    }

    @Override
    @Nullable
    public EmiStack toEmiStack(GenericStack stack) {
        AEKey aEKey = stack.what();
        if (aEKey instanceof AEFluidKey) {
            AEFluidKey fluidKey = (AEFluidKey)aEKey;
            return EmiStack.of((Fluid)fluidKey.getFluid(), (CompoundTag)fluidKey.copyTag(), (long)stack.amount());
        }
        return null;
    }

    @Override
    @Nullable
    public GenericStack toGenericStack(EmiStack stack) {
        Fluid fluid = (Fluid)stack.getKeyOfType(Fluid.class);
        if (fluid != null && fluid != Fluids.EMPTY) {
            AEFluidKey fluidKey = AEFluidKey.of(fluid, stack.getNbt());
            return new GenericStack(fluidKey, stack.getAmount());
        }
        return null;
    }
}

