/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.emi;

import appeng.api.integrations.emi.EmiStackConverter;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

class EmiItemStackConverter
implements EmiStackConverter {
    EmiItemStackConverter() {
    }

    @Override
    public Class<?> getKeyType() {
        return Item.class;
    }

    @Override
    @Nullable
    public EmiStack toEmiStack(GenericStack stack) {
        AEKey aEKey = stack.what();
        if (aEKey instanceof AEFluidKey) {
            AEFluidKey fluidKey = (AEFluidKey)aEKey;
            return EmiStack.of((Fluid)fluidKey.getFluid(), (CompoundTag)fluidKey.copyTag(), (long)stack.amount());
        }
        return null;
    }

    @Override
    @Nullable
    public GenericStack toGenericStack(EmiStack stack) {
        Item item = (Item)stack.getKeyOfType(Item.class);
        if (item != null && item != Items.AIR) {
            AEItemKey itemKey = AEItemKey.of((ItemLike)item, stack.getNbt());
            return new GenericStack(itemKey, stack.getAmount());
        }
        return null;
    }
}

