/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.contents;

import appeng.api.config.Actionable;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.upgrades.Upgrades;
import appeng.items.contents.StackDependentSupplier;
import appeng.items.tools.NetworkToolItem;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.SupplierInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import com.google.common.primitives.Ints;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class NetworkToolMenuHost<T extends NetworkToolItem>
extends ItemMenuHost<T> {
    @Nullable
    private final IInWorldGridNodeHost host;
    private final SupplierInternalInventory<InternalInventory> supplierInv;

    public NetworkToolMenuHost(T item, Player player, ItemMenuHostLocator locator, @Nullable IInWorldGridNodeHost host) {
        super(item, player, locator);
        this.host = host;
        this.supplierInv = new SupplierInternalInventory<InternalInventory>(new StackDependentSupplier<InternalInventory>(this::getItemStack, this::createToolboxInventory));
    }

    private InternalInventory createToolboxInventory(final ItemStack stack) {
        AppEngInternalInventory inv = new AppEngInternalInventory(new InternalInventoryHost(){

            @Override
            public void saveChangedInventory(AppEngInternalInventory inv) {
                inv.writeToNBT(stack.getOrCreateTag(), "inv");
            }

            @Override
            public boolean isClientSide() {
                return NetworkToolMenuHost.this.getPlayer().level().isClientSide();
            }
        }, 9);
        inv.setEnableClientEvents(true);
        inv.setFilter(new NetworkToolInventoryFilter());
        if (stack.hasTag()) {
            inv.readFromNBT(stack.getOrCreateTag(), "inv");
        }
        return inv;
    }

    @Override
    public long insert(Player player, AEKey what, long amount, Actionable mode) {
        if (what instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)what;
            ItemStack stack = itemKey.toStack(Ints.saturatedCast((long)amount));
            ItemStack overflow = this.getInventory().addItems(stack, mode.isSimulate());
            return stack.getCount() - overflow.getCount();
        }
        return 0L;
    }

    @Nullable
    public IInWorldGridNodeHost getGridHost() {
        return this.host;
    }

    public InternalInventory getInventory() {
        return this.supplierInv;
    }

    private static class NetworkToolInventoryFilter
    implements IAEItemFilter {
        private NetworkToolInventoryFilter() {
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return Upgrades.isUpgradeCardItem((ItemLike)stack.getItem());
        }
    }
}

