/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.inventories.InternalInventory;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.AEColor;
import appeng.api.util.IConfigurableObject;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.core.localization.Tooltips;
import appeng.helpers.IConfigInvHost;
import appeng.helpers.IPriorityHost;
import appeng.items.AEBaseItem;
import appeng.items.contents.NetworkToolMenuHost;
import appeng.items.tools.NetworkToolItem;
import appeng.items.tools.SettingsCategory;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import appeng.util.inv.PlayerInternalInventory;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class MemoryCardItem
extends AEBaseItem
implements IMemoryCard,
DyeableLeatherItem {
    private static final int DEFAULT_BASE_COLOR = 0xDDDDDD;
    private static final AEColor[] DEFAULT_COLOR_CODE = new AEColor[]{AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT};

    public MemoryCardItem(Item.Properties properties) {
        super(properties);
    }

    public static Set<SettingsCategory> exportGenericSettings(Object exportFrom, CompoundTag output) {
        EnumSet<SettingsCategory> exported = EnumSet.noneOf(SettingsCategory.class);
        if (exportFrom instanceof IUpgradeableObject) {
            IUpgradeableObject upgradeableObject = (IUpgradeableObject)exportFrom;
            MemoryCardItem.storeUpgrades(upgradeableObject, output);
            exported.add(SettingsCategory.UPGRADES);
        }
        if (exportFrom instanceof IConfigurableObject) {
            IConfigurableObject configurableObject = (IConfigurableObject)exportFrom;
            configurableObject.getConfigManager().writeToNBT(output);
            exported.add(SettingsCategory.SETTINGS);
        }
        if (exportFrom instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)exportFrom;
            output.putInt("priority", pHost.getPriority());
            exported.add(SettingsCategory.PRIORITY);
        }
        if (exportFrom instanceof IConfigInvHost) {
            IConfigInvHost configInvHost = (IConfigInvHost)exportFrom;
            configInvHost.getConfig().writeToChildTag(output, "config");
            exported.add(SettingsCategory.CONFIG_INV);
        }
        return exported;
    }

    public static Set<SettingsCategory> importGenericSettings(Object importTo, CompoundTag input, @Nullable Player player) {
        IConfigurableObject configurableObject;
        IUpgradeableObject upgradeableObject;
        EnumSet<SettingsCategory> imported = EnumSet.noneOf(SettingsCategory.class);
        if (player != null && importTo instanceof IUpgradeableObject && MemoryCardItem.restoreUpgrades(player, input, upgradeableObject = (IUpgradeableObject)importTo)) {
            imported.add(SettingsCategory.UPGRADES);
        }
        if (importTo instanceof IConfigurableObject && (configurableObject = (IConfigurableObject)importTo).getConfigManager().readFromNBT(input)) {
            imported.add(SettingsCategory.SETTINGS);
        }
        if (importTo instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)importTo;
            if (input.contains("priority", 3)) {
                pHost.setPriority(input.getInt("priority"));
                imported.add(SettingsCategory.PRIORITY);
            }
        }
        if (importTo instanceof IConfigInvHost) {
            IConfigInvHost configInvHost = (IConfigInvHost)importTo;
            if (input.contains("config")) {
                configInvHost.getConfig().readFromChildTag(input, "config");
                imported.add(SettingsCategory.CONFIG_INV);
            }
        }
        return imported;
    }

    public static void importGenericSettingsAndNotify(Object importTo, CompoundTag input, @Nullable Player player) {
        Set<SettingsCategory> imported = MemoryCardItem.importGenericSettings(importTo, input, player);
        if (player != null && !player.getCommandSenderWorld().isClientSide()) {
            if (imported.isEmpty()) {
                player.displayClientMessage((Component)PlayerMessages.InvalidMachine.text(), true);
            } else {
                Component restored = Tooltips.conjunction(imported.stream().map(SettingsCategory::getLabel).toList());
                player.displayClientMessage((Component)PlayerMessages.InvalidMachinePartiallyRestored.text(restored), true);
            }
        }
    }

    private static void storeUpgrades(IUpgradeableObject upgradeableObject, CompoundTag output) {
        CompoundTag desiredUpgradesTag = new CompoundTag();
        for (ItemStack upgrade : upgradeableObject.getUpgrades()) {
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)upgrade.getItem());
            if (itemId.equals((Object)BuiltInRegistries.ITEM.getDefaultKey())) {
                AELog.warn("Cannot save unregistered upgrade to memory card %s", upgrade.getItem());
                continue;
            }
            String key = itemId.toString();
            desiredUpgradesTag.putInt(key, desiredUpgradesTag.getInt(key) + upgrade.getCount());
        }
        output.put("upgrades", (Tag)desiredUpgradesTag);
    }

    private static boolean restoreUpgrades(Player player, CompoundTag input, IUpgradeableObject upgradeableObject) {
        if (!input.contains("upgrades", 10)) {
            return false;
        }
        CompoundTag desiredUpgradesTag = input.getCompound("upgrades");
        IdentityHashMap<Item, Integer> desiredUpgrades = new IdentityHashMap<Item, Integer>();
        for (String itemIdStr : desiredUpgradesTag.getAllKeys()) {
            ResourceLocation itemId;
            try {
                itemId = new ResourceLocation(itemIdStr);
            }
            catch (ResourceLocationException e) {
                AELog.warn("Memory card contains invalid item id %s", itemIdStr);
                continue;
            }
            Item item = BuiltInRegistries.ITEM.getOptional(itemId).orElse(null);
            if (item == null) {
                AELog.warn("Memory card contains unknown item id %s", itemId);
                continue;
            }
            int desiredCount = desiredUpgradesTag.getInt(itemIdStr);
            if (desiredCount <= 0) continue;
            desiredUpgrades.put(item, desiredCount);
        }
        IUpgradeInventory upgrades = upgradeableObject.getUpgrades();
        if (player.getAbilities().instabuild) {
            for (int i = 0; i < upgrades.size(); ++i) {
                upgrades.setItemDirect(i, ItemStack.EMPTY);
            }
            for (Map.Entry entry : desiredUpgrades.entrySet()) {
                upgrades.addItems(new ItemStack((ItemLike)entry.getKey(), ((Integer)entry.getValue()).intValue()));
            }
            return true;
        }
        ArrayList<InternalInventory> upgradeSources = new ArrayList<InternalInventory>();
        upgradeSources.add(new PlayerInternalInventory(player.getInventory()));
        NetworkToolMenuHost networkTool = NetworkToolItem.findNetworkToolInv(player);
        if (networkTool != null) {
            upgradeSources.add(networkTool.getInventory());
        }
        for (int i = 0; i < upgrades.size(); ++i) {
            ItemStack current = upgrades.getStackInSlot(i);
            if (current.isEmpty()) continue;
            Integer desiredCount = desiredUpgrades.getOrDefault(current.getItem(), 0);
            int totalInstalled = upgradeableObject.getInstalledUpgrades((ItemLike)current.getItem());
            int toRemove = totalInstalled - desiredCount;
            if (toRemove <= 0) continue;
            ItemStack removed = upgrades.extractItem(i, toRemove, false);
            for (InternalInventory upgradeSource : upgradeSources) {
                if (removed.isEmpty()) continue;
                removed = upgradeSource.addItems(removed);
            }
            if (removed.isEmpty()) continue;
            player.drop(removed, false);
        }
        for (Map.Entry entry : desiredUpgrades.entrySet()) {
            int missingAmount = (Integer)entry.getValue() - upgradeableObject.getInstalledUpgrades((ItemLike)entry.getKey());
            if (missingAmount <= 0) continue;
            ItemStack potential = new ItemStack((ItemLike)entry.getKey(), missingAmount);
            ItemStack overflow = upgrades.addItems(potential, true);
            if (!overflow.isEmpty()) {
                missingAmount -= overflow.getCount();
            }
            for (InternalInventory upgradeSource : upgradeSources) {
                ItemStack cards = upgradeSource.removeItems(missingAmount, potential, null);
                if (!cards.isEmpty()) {
                    overflow = upgrades.addItems(cards);
                    if (!overflow.isEmpty()) {
                        player.getInventory().placeItemBackInInventory(overflow);
                    }
                    missingAmount -= cards.getCount();
                }
                if (missingAmount > 0) continue;
                break;
            }
            if (missingAmount <= 0 || player.level().isClientSide()) continue;
            player.displayClientMessage((Component)PlayerMessages.MissingUpgrades.text(((Item)entry.getKey()).getDescription(), missingAmount), true);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        String firstLineKey = this.getFirstValidTranslationKey(this.getSettingsName(stack) + ".name", this.getSettingsName(stack));
        lines.add((Component)Tooltips.of((Component)Component.translatable((String)firstLineKey)));
        CompoundTag data = this.getData(stack);
        if (data.contains("tooltip")) {
            String tooltipKey = this.getFirstValidTranslationKey(data.getString("tooltip") + ".name", data.getString("tooltip"));
            lines.add((Component)Tooltips.of((Component)Component.translatable((String)tooltipKey)));
        }
        if (data.contains("freq")) {
            short freq = data.getShort("freq");
            String freqTooltip = ChatFormatting.BOLD + Platform.p2p().toHexString(freq);
            lines.add((Component)Tooltips.of((Component)Component.translatable((String)"gui.tooltips.ae2.P2PFrequency", (Object[])new Object[]{freqTooltip})));
        }
    }

    private String getFirstValidTranslationKey(String ... name) {
        for (String n3 : name) {
            if (!I18n.exists((String)n3)) continue;
            return n3;
        }
        int n = 0;
        String[] stringArray = name;
        int n2 = stringArray.length;
        if (n < n2) {
            String n3;
            n3 = stringArray[n];
            return n3;
        }
        return "";
    }

    @Override
    public void setMemoryCardContents(ItemStack is, String settingsName, CompoundTag data) {
        CompoundTag c = is.getOrCreateTag();
        c.putString("Config", settingsName);
        c.put("Data", (Tag)data);
    }

    @Override
    public String getSettingsName(ItemStack is) {
        CompoundTag c = is.getOrCreateTag();
        String name = c.getString("Config");
        return name.isEmpty() ? GuiText.Blank.getTranslationKey() : name;
    }

    @Override
    public CompoundTag getData(ItemStack is) {
        CompoundTag c = is.getOrCreateTag();
        CompoundTag o = c.getCompound("Data");
        return o.copy();
    }

    @Override
    public AEColor[] getColorCode(ItemStack is) {
        CompoundTag tag = this.getData(is);
        if (tag.contains("colorCode", 11)) {
            int[] frequency = tag.getIntArray("colorCode");
            AEColor[] colorArray = AEColor.values();
            if (frequency.length == 8) {
                return new AEColor[]{colorArray[frequency[0]], colorArray[frequency[1]], colorArray[frequency[2]], colorArray[frequency[3]], colorArray[frequency[4]], colorArray[frequency[5]], colorArray[frequency[6]], colorArray[frequency[7]]};
            }
        }
        return DEFAULT_COLOR_CODE;
    }

    @Override
    public void notifyUser(Player player, MemoryCardMessages msg) {
        if (player.getCommandSenderWorld().isClientSide()) {
            return;
        }
        switch (msg) {
            case SETTINGS_CLEARED: {
                player.displayClientMessage((Component)PlayerMessages.SettingCleared.text(), true);
                break;
            }
            case INVALID_MACHINE: {
                player.displayClientMessage((Component)PlayerMessages.InvalidMachine.text(), true);
                break;
            }
            case SETTINGS_LOADED: {
                player.displayClientMessage((Component)PlayerMessages.LoadedSettings.text(), true);
                break;
            }
            case SETTINGS_SAVED: {
                player.displayClientMessage((Component)PlayerMessages.SavedSettings.text(), true);
                break;
            }
            case SETTINGS_RESET: {
                player.displayClientMessage((Component)PlayerMessages.ResetSettings.text(), true);
                break;
            }
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        if (InteractionUtil.isInAlternateUseMode(context.getPlayer())) {
            Level level = context.getLevel();
            if (!level.isClientSide()) {
                this.clearCard(context.getPlayer(), context.getLevel(), context.getHand());
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useOn(context);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (InteractionUtil.isInAlternateUseMode(player) && !level.isClientSide) {
            this.clearCard(player, level, hand);
        }
        return super.use(level, player, hand);
    }

    private void clearCard(Player player, Level level, InteractionHand hand) {
        IMemoryCard mem = (IMemoryCard)player.getItemInHand(hand).getItem();
        mem.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
        player.getItemInHand(hand).setTag(null);
    }

    public int getColor(ItemStack stack) {
        CompoundTag compoundTag = stack.getTagElement("display");
        if (compoundTag != null && compoundTag.contains("color", 99)) {
            return compoundTag.getInt("color");
        }
        return 0xDDDDDD;
    }

    public static int getTintColor(ItemStack stack, int tintIndex) {
        Item item;
        if (tintIndex == 1 && (item = stack.getItem()) instanceof MemoryCardItem) {
            MemoryCardItem memoryCard = (MemoryCardItem)item;
            return memoryCard.getColor(stack);
        }
        return 0xFFFFFF;
    }
}

