/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.implementations;

import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.inventories.InternalInventory;
import appeng.client.gui.Icon;
import appeng.core.definitions.AEItems;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.slot.OutputSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.inv.AppEngInternalInventory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerDestroyItemEvent;

public class QuartzKnifeMenu
extends AEBaseMenu {
    private static final String ACTION_SET_NAME = "setName";
    public static final MenuType<QuartzKnifeMenu> TYPE = MenuTypeBuilder.create(QuartzKnifeMenu::new, ItemMenuHost.class).build("quartzknife");
    private final InternalInventory inSlot = new AppEngInternalInventory(null, 1, 1);
    private String currentName = "";

    public QuartzKnifeMenu(int id, Inventory ip, ItemMenuHost<?> host) {
        super(TYPE, id, ip, host);
        this.addSlot(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.METAL_INGOTS, this.inSlot, 0), SlotSemantics.MACHINE_INPUT);
        this.addSlot(new QuartzKniveSlot(this.inSlot, 0, null), SlotSemantics.MACHINE_OUTPUT);
        this.createPlayerInventorySlots(ip);
        this.registerClientAction(ACTION_SET_NAME, String.class, this::setName);
    }

    public void setName(String value) {
        this.currentName = value;
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_NAME, value);
        }
    }

    public void removed(Player player) {
        ItemStack item = this.inSlot.extractItem(0, Integer.MAX_VALUE, false);
        if (!item.isEmpty()) {
            player.drop(item, false);
        }
    }

    private class QuartzKniveSlot
    extends OutputSlot {
        QuartzKniveSlot(InternalInventory inv, int invSlot, Icon icon) {
            super(inv, invSlot, icon);
        }

        @Override
        public ItemStack getItem() {
            InternalInventory baseInv = this.getInventory();
            ItemStack input = baseInv.getStackInSlot(0);
            if (input == ItemStack.EMPTY) {
                return ItemStack.EMPTY;
            }
            if (RestrictedInputSlot.isMetalIngot(input) && QuartzKnifeMenu.this.currentName.length() > 0) {
                ItemStack namePressStack = AEItems.NAME_PRESS.stack();
                CompoundTag compound = namePressStack.getOrCreateTag();
                compound.putString("InscribeName", QuartzKnifeMenu.this.currentName);
                return namePressStack;
            }
            return ItemStack.EMPTY;
        }

        @Override
        public ItemStack remove(int amount) {
            ItemStack ret = this.getItem();
            if (!ret.isEmpty()) {
                this.makePlate();
            }
            return ret;
        }

        @Override
        public void set(ItemStack stack) {
            if (stack.isEmpty()) {
                this.makePlate();
            }
        }

        @Override
        public void initialize(ItemStack stack) {
        }

        private void makePlate() {
            if (QuartzKnifeMenu.this.isServerSide() && !this.getInventory().extractItem(0, 1, false).isEmpty()) {
                ItemStack item = QuartzKnifeMenu.this.itemMenuHost.getItemStack();
                ItemStack before = item.copy();
                Inventory playerInv = QuartzKnifeMenu.this.getPlayerInventory();
                item.hurtAndBreak(1, (LivingEntity)playerInv.player, p -> {
                    playerInv.setItem(playerInv.selected, ItemStack.EMPTY);
                    NeoForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(playerInv.player, before, null));
                });
                QuartzKnifeMenu.this.broadcastChanges();
            }
        }
    }
}

