/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.slot;

import appeng.api.inventories.InternalInventory;
import appeng.helpers.Inventories;
import appeng.menu.slot.AppEngSlot;
import appeng.util.inv.AppEngInternalInventory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class AppEngCraftingSlot
extends AppEngSlot
implements RecipeCraftingHolder {
    private final InternalInventory craftingGrid;
    private final Player player;
    private int amountCrafted;
    @Nullable
    private RecipeHolder<?> recipeUsed;

    public AppEngCraftingSlot(Player player, InternalInventory craftingGrid) {
        super(new AppEngInternalInventory(1), 0);
        this.player = player;
        this.craftingGrid = craftingGrid;
    }

    @Override
    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    protected void onQuickCraft(ItemStack stack, int amount) {
        this.amountCrafted += amount;
        this.checkTakeAchievements(stack);
    }

    protected void checkTakeAchievements(ItemStack stack) {
        Container craftContainer = this.craftingGrid.toContainer();
        if (this.amountCrafted > 0) {
            stack.onCraftedBy(this.player.level(), this.player, this.amountCrafted);
            EventHooks.firePlayerCraftingEvent((Player)this.player, (ItemStack)stack, (Container)craftContainer);
        }
        ArrayList ingredients = Lists.newArrayList((Iterable)this.craftingGrid);
        this.awardUsedRecipes(this.player, ingredients);
        this.amountCrafted = 0;
    }

    public void onTake(Player player, ItemStack stack) {
        this.amountCrafted += stack.getCount();
        this.checkTakeAchievements(stack);
        CommonHooks.setCraftingPlayer((Player)player);
        TransientCraftingContainer ic = new TransientCraftingContainer((AbstractContainerMenu)this.getMenu(), 3, 3);
        for (int x = 0; x < this.craftingGrid.size(); ++x) {
            ic.setItem(x, this.craftingGrid.getStackInSlot(x));
        }
        NonNullList<ItemStack> aitemstack = this.getRemainingItems((CraftingContainer)ic, player.level());
        Inventories.copy((CraftingContainer)ic, this.craftingGrid, false);
        CommonHooks.setCraftingPlayer(null);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack1 = this.craftingGrid.getStackInSlot(i);
            ItemStack itemstack2 = (ItemStack)aitemstack.get(i);
            if (!itemstack1.isEmpty()) {
                this.craftingGrid.extractItem(i, 1, false);
            }
            if (itemstack2.isEmpty()) continue;
            if (this.craftingGrid.getStackInSlot(i).isEmpty()) {
                this.craftingGrid.setItemDirect(i, itemstack2);
                continue;
            }
            if (this.player.getInventory().add(itemstack2)) continue;
            this.player.drop(itemstack2, false);
        }
    }

    public void setDisplayedCraftingOutput(ItemStack stack) {
        this.getInventory().setItemDirect(0, stack);
    }

    @Override
    public ItemStack remove(int par1) {
        if (this.hasItem()) {
            this.amountCrafted += Math.min(par1, this.getItem().getCount());
        }
        return super.remove(par1);
    }

    protected NonNullList<ItemStack> getRemainingItems(CraftingContainer ic, Level level) {
        return level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)ic, level).map(recipe -> ((CraftingRecipe)recipe.value()).getRemainingItems((Container)ic)).orElse(NonNullList.withSize((int)9, (Object)ItemStack.EMPTY));
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        this.recipeUsed = recipe;
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return this.recipeUsed;
    }
}

