/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.items.parts.PartItem;
import appeng.parts.automation.AnnihilationPlanePart;
import appeng.util.EnchantmentUtil;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AnnihilationPlanePartItem
extends PartItem<AnnihilationPlanePart> {
    public static final ThreadLocal<Object> CALLING_DAMAGEABLE_FROM_ANVIL = ThreadLocal.withInitial(() -> null);

    public AnnihilationPlanePartItem(Item.Properties properties) {
        super(properties, AnnihilationPlanePart.class, AnnihilationPlanePart::new);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 10;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.category == EnchantmentCategory.DIGGER;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return CALLING_DAMAGEABLE_FROM_ANVIL.get() != null ? 1 : super.getMaxDamage();
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, level, lines, isAdvanced);
        Map enchantments = EnchantmentHelper.getEnchantments((ItemStack)stack);
        if (enchantments.isEmpty()) {
            lines.add((Component)Tooltips.of(GuiText.CanBeEnchanted, new Object[0]));
        } else {
            lines.add((Component)Tooltips.of(GuiText.IncreasedEnergyUseFromEnchants, new Object[0]));
        }
    }

    @Override
    public void addToMainCreativeTab(CreativeModeTab.Output output) {
        super.addToMainCreativeTab(output);
        ItemStack silkTouch = new ItemStack((ItemLike)this);
        EnchantmentUtil.setEnchantments(silkTouch.getOrCreateTag(), Map.of(Enchantments.SILK_TOUCH, 1));
        output.accept(silkTouch);
    }
}

