/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.implementations.parts.IMonitorPart;
import appeng.api.networking.GridFlags;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.client.render.model.AEModelData;
import appeng.parts.AEBasePart;
import appeng.util.InteractionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;

public abstract class AbstractReportingPart
extends AEBasePart
implements IMonitorPart {
    private byte spin = 0;
    private int opacity = -1;

    protected AbstractReportingPart(IPartItem<?> partItem, boolean requireChannel) {
        super(partItem);
        if (requireChannel) {
            this.getMainNode().setFlags(GridFlags.REQUIRE_CHANNEL);
            this.getMainNode().setIdlePowerUsage(0.5);
        } else {
            this.getMainNode().setIdlePowerUsage(0.0625);
        }
    }

    @Override
    public final void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
    }

    @Override
    public void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        if (pos.relative(this.getSide()).equals((Object)neighbor)) {
            this.opacity = -1;
            this.getHost().markForUpdate();
        }
    }

    @Override
    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.spin = data.getByte("spin");
    }

    @Override
    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        data.putByte("spin", this.getSpin());
    }

    @Override
    public void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeByte(this.getSpin());
    }

    @Override
    public boolean readFromStream(FriendlyByteBuf data) {
        boolean changed = super.readFromStream(data);
        byte oldSpin = this.spin;
        this.spin = data.readByte();
        return changed || oldSpin != this.spin;
    }

    @Override
    public final int getLightLevel() {
        return this.blockLight(this.isPowered() ? (this.isLightSource() ? 15 : 9) : 0);
    }

    @Override
    public boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        if (InteractionUtil.canWrenchRotate(player.getInventory().getSelected())) {
            if (!this.isClientSide()) {
                this.spin = (byte)((this.spin + 1) % 4);
                this.getHost().markForUpdate();
                this.getHost().markForSave();
            }
            return true;
        }
        return super.onPartActivate(player, hand, pos);
    }

    @Override
    public final void onPlacement(Player player) {
        super.onPlacement(player);
        byte rotation = (byte)(Mth.floor((double)((double)(player.getYRot() * 4.0f / 360.0f) + 2.5)) & 3);
        if (this.getSide() == Direction.UP || this.getSide() == Direction.DOWN) {
            this.spin = rotation;
        }
    }

    private int blockLight(int emit) {
        if (this.opacity == -1) {
            BlockEntity te = this.getHost().getBlockEntity();
            Level level = te.getLevel();
            BlockPos pos = te.getBlockPos().relative(this.getSide());
            this.opacity = level.getBlockState(pos).getLightBlock((BlockGetter)level, pos);
        }
        return Math.max(0, emit - this.opacity);
    }

    protected IPartModel selectModel(IPartModel offModels, IPartModel onModels, IPartModel hasChannelModels) {
        if (this.isActive()) {
            return hasChannelModels;
        }
        if (this.isPowered()) {
            return onModels;
        }
        return offModels;
    }

    @Override
    public ModelData getModelData() {
        return ModelData.builder().with(AEModelData.SPIN, (Object)this.getSpin()).build();
    }

    public final byte getSpin() {
        return this.spin;
    }

    public abstract boolean isLightSource();
}

