/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.core.AppEng;
import appeng.init.InitRecipeTypes;
import appeng.recipes.handlers.ChargerRecipeSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ChargerRecipe
implements Recipe<Container> {
    public static final ResourceLocation TYPE_ID = AppEng.makeId("charger");
    public static final RecipeType<ChargerRecipe> TYPE = InitRecipeTypes.register(TYPE_ID.toString());
    public final Ingredient ingredient;
    public final NonNullList<Ingredient> ingredients;
    public final Item result;
    public static final Codec<ChargerRecipe> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(ChargerRecipe::getIngredient), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("result").xmap(ItemStack::getItem, ItemStack::new).forGetter(cr -> cr.result)).apply((Applicative)builder, ChargerRecipe::new));

    public ChargerRecipe(Ingredient ingredient, Item result) {
        this.ingredient = ingredient;
        this.result = result;
        this.ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{ingredient});
    }

    public boolean matches(Container container, Level level) {
        return false;
    }

    public ItemStack assemble(Container container, RegistryAccess registryAccess) {
        return null;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        return this.getResultItem();
    }

    public ItemStack getResultItem() {
        return new ItemStack((ItemLike)this.result);
    }

    public RecipeSerializer<?> getSerializer() {
        return ChargerRecipeSerializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return TYPE;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean isSpecial() {
        return true;
    }
}

