/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.core.AppEng;
import appeng.init.InitRecipeTypes;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipeSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class InscriberRecipe
implements Recipe<Container> {
    private static final Codec<InscriberProcessType> MODE_CODEC = ExtraCodecs.stringResolverCodec(mode -> switch (mode) {
        default -> throw new IncompatibleClassChangeError();
        case InscriberProcessType.INSCRIBE -> "inscribe";
        case InscriberProcessType.PRESS -> "press";
    }, mode -> switch (mode) {
        default -> InscriberProcessType.INSCRIBE;
        case "press" -> InscriberProcessType.PRESS;
    });
    public static final Codec<InscriberRecipe> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredients.CODEC.fieldOf("ingredients").forGetter(InscriberRecipe::getSerializedIngredients), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("result").forGetter(ir -> ir.output), (App)MODE_CODEC.fieldOf("mode").forGetter(ir -> ir.processType)).apply((Applicative)builder, InscriberRecipe::new));
    public static final ResourceLocation TYPE_ID = AppEng.makeId("inscriber");
    public static final RecipeType<InscriberRecipe> TYPE = InitRecipeTypes.register(TYPE_ID.toString());
    private final Ingredient middleInput;
    private final Ingredient topOptional;
    private final Ingredient bottomOptional;
    private final ItemStack output;
    private final InscriberProcessType processType;

    private InscriberRecipe(Ingredients ingredients, ItemStack output, InscriberProcessType processType) {
        this(ingredients.middle(), output, ingredients.top(), ingredients.bottom(), processType);
    }

    public InscriberRecipe(Ingredient middleInput, ItemStack output, Ingredient topOptional, Ingredient bottomOptional, InscriberProcessType processType) {
        this.middleInput = Objects.requireNonNull(middleInput, "middleInput");
        this.output = Objects.requireNonNull(output, "output");
        this.topOptional = Objects.requireNonNull(topOptional, "topOptional");
        this.bottomOptional = Objects.requireNonNull(bottomOptional, "bottomOptional");
        this.processType = Objects.requireNonNull(processType, "processType");
    }

    public boolean matches(Container inv, Level level) {
        return false;
    }

    public ItemStack assemble(Container inv, RegistryAccess registryAccess) {
        return this.getResultItem(registryAccess).copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        return this.getResultItem();
    }

    public ItemStack getResultItem() {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return InscriberRecipeSerializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return TYPE;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.create();
        ingredients.add((Object)this.topOptional);
        ingredients.add((Object)this.middleInput);
        ingredients.add((Object)this.bottomOptional);
        return ingredients;
    }

    public Ingredient getMiddleInput() {
        return this.middleInput;
    }

    public Ingredient getTopOptional() {
        return this.topOptional;
    }

    public Ingredient getBottomOptional() {
        return this.bottomOptional;
    }

    public InscriberProcessType getProcessType() {
        return this.processType;
    }

    public boolean isSpecial() {
        return true;
    }

    private Ingredients getSerializedIngredients() {
        return new Ingredients(this.topOptional, this.middleInput, this.bottomOptional);
    }

    private record Ingredients(Ingredient top, Ingredient middle, Ingredient bottom) {
        public static final Codec<Ingredients> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ExtraCodecs.strictOptionalField((Codec)Ingredient.CODEC, (String)"top", (Object)Ingredient.EMPTY).forGetter(Ingredients::top), (App)Ingredient.CODEC_NONEMPTY.fieldOf("middle").forGetter(Ingredients::middle), (App)ExtraCodecs.strictOptionalField((Codec)Ingredient.CODEC, (String)"bottom", (Object)Ingredient.EMPTY).forGetter(Ingredients::bottom)).apply((Applicative)builder, Ingredients::new));
    }
}

