/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import com.mojang.serialization.Codec;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;

public class InscriberRecipeSerializer
implements RecipeSerializer<InscriberRecipe> {
    public static final InscriberRecipeSerializer INSTANCE = new InscriberRecipeSerializer();

    private InscriberRecipeSerializer() {
    }

    public Codec<InscriberRecipe> codec() {
        return InscriberRecipe.CODEC;
    }

    @Nullable
    public InscriberRecipe fromNetwork(FriendlyByteBuf buffer) {
        Ingredient middle = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        ItemStack result = buffer.readItem();
        Ingredient top = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        Ingredient bottom = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        InscriberProcessType mode = (InscriberProcessType)buffer.readEnum(InscriberProcessType.class);
        return new InscriberRecipe(middle, result, top, bottom, mode);
    }

    public void toNetwork(FriendlyByteBuf buffer, InscriberRecipe recipe) {
        recipe.getMiddleInput().toNetwork(buffer);
        buffer.writeItem(recipe.getResultItem());
        recipe.getTopOptional().toNetwork(buffer);
        recipe.getBottomOptional().toNetwork(buffer);
        buffer.writeEnum((Enum)recipe.getProcessType());
    }
}

