/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.mattercannon;

import appeng.recipes.mattercannon.MatterCannonAmmo;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;

public class MatterCannonAmmoSerializer
implements RecipeSerializer<MatterCannonAmmo> {
    public static final MatterCannonAmmoSerializer INSTANCE = new MatterCannonAmmoSerializer();
    private static final Codec<MatterCannonAmmo> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ammo").forGetter(MatterCannonAmmo::getAmmo), (App)Codec.FLOAT.fieldOf("weight").forGetter(MatterCannonAmmo::getWeight)).apply((Applicative)builder, MatterCannonAmmo::new));

    private MatterCannonAmmoSerializer() {
    }

    public Codec<MatterCannonAmmo> codec() {
        return CODEC;
    }

    @Nullable
    public MatterCannonAmmo fromNetwork(FriendlyByteBuf buffer) {
        Ingredient ammo = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        float weight = buffer.readFloat();
        return new MatterCannonAmmo(ammo, weight);
    }

    public void toNetwork(FriendlyByteBuf buffer, MatterCannonAmmo recipe) {
        recipe.getAmmo().toNetwork(buffer);
        buffer.writeFloat(recipe.getWeight());
    }
}

