/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.transform;

import appeng.recipes.transform.TransformCircumstance;
import appeng.recipes.transform.TransformRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class TransformRecipeSerializer
implements RecipeSerializer<TransformRecipe> {
    public static final TransformRecipeSerializer INSTANCE = new TransformRecipeSerializer();
    private static final Codec<TransformRecipe> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(ingredients -> DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])((Ingredient[])ingredients.toArray(Ingredient[]::new)))), DataResult::success).forGetter(r -> r.ingredients), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("result").forGetter(r -> r.output), (App)ExtraCodecs.strictOptionalField(TransformCircumstance.CODEC, (String)"circumstance", (Object)TransformCircumstance.fluid((TagKey<Fluid>)FluidTags.WATER)).forGetter(t -> t.circumstance)).apply((Applicative)builder, TransformRecipe::new));

    private TransformRecipeSerializer() {
    }

    public Codec<TransformRecipe> codec() {
        return CODEC;
    }

    @Nullable
    public TransformRecipe fromNetwork(FriendlyByteBuf buffer) {
        ItemStack output = buffer.readItem();
        int size = buffer.readByte();
        NonNullList ingredients = NonNullList.create();
        for (int i = 0; i < size; ++i) {
            ingredients.add((Object)Ingredient.fromNetwork((FriendlyByteBuf)buffer));
        }
        TransformCircumstance circumstance = TransformCircumstance.fromNetwork(buffer);
        return new TransformRecipe((NonNullList<Ingredient>)ingredients, output, circumstance);
    }

    public void toNetwork(FriendlyByteBuf buffer, TransformRecipe recipe) {
        buffer.writeItem(recipe.output);
        buffer.writeByte(recipe.ingredients.size());
        recipe.ingredients.forEach(ingredient -> ingredient.toNetwork(buffer));
        recipe.circumstance.toNetwork(buffer);
    }
}

