/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.services.compass;

import appeng.core.definitions.AEBlocks;
import appeng.server.services.compass.CompassRegion;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;

public final class CompassService {
    private static final LoadingCache<DirectionQuery, Result> DIRECTION_CACHE = CacheBuilder.newBuilder().maximumSize(100L).weakKeys().expireAfterWrite(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<DirectionQuery, Result>(){

        public Result load(DirectionQuery directionQuery) {
            return CompassService.calculateCompassDirection(directionQuery);
        }
    });
    private static final int CHUNK_SIZE = 16;

    public static Result getDirection(ServerLevel level, ChunkPos chunkPos, int maxRange) {
        return (Result)DIRECTION_CACHE.getUnchecked((Object)new DirectionQuery(level, chunkPos.x, chunkPos.z, maxRange));
    }

    private static Result calculateCompassDirection(DirectionQuery query) {
        int cz;
        int cx;
        CompassRegion cr = CompassRegion.get(query.level(), new ChunkPos(query.cx(), query.cz()));
        if (cr.hasSkyStone(cx = query.cx(), cz = query.cz())) {
            return Result.ON_THE_SPOT;
        }
        for (int offset = 1; offset < query.maxRange(); ++offset) {
            int closeness;
            int minX = cx - offset;
            int minZ = cz - offset;
            int maxX = cx + offset;
            int maxZ = cz + offset;
            int closest = Integer.MAX_VALUE;
            int chosen_x = cx;
            int chosen_z = cz;
            for (int z = minZ; z <= maxZ; ++z) {
                if (cr.hasSkyStone(minX, z) && (closeness = CompassService.dist(cx, cz, minX, z)) < closest) {
                    closest = closeness;
                    chosen_x = minX;
                    chosen_z = z;
                }
                if (!cr.hasSkyStone(maxX, z) || (closeness = CompassService.dist(cx, cz, maxX, z)) >= closest) continue;
                closest = closeness;
                chosen_x = maxX;
                chosen_z = z;
            }
            for (int x = minX + 1; x < maxX; ++x) {
                if (cr.hasSkyStone(x, minZ) && (closeness = CompassService.dist(cx, cz, x, minZ)) < closest) {
                    closest = closeness;
                    chosen_x = x;
                    chosen_z = minZ;
                }
                if (!cr.hasSkyStone(x, maxZ) || (closeness = CompassService.dist(cx, cz, x, maxZ)) >= closest) continue;
                closest = closeness;
                chosen_x = x;
                chosen_z = maxZ;
            }
            if (closest >= Integer.MAX_VALUE) continue;
            return new Result(true, false, CompassService.rad(cx, cz, chosen_x, chosen_z), CompassService.dist(cx, cz, chosen_x, chosen_z));
        }
        return Result.INDETERMINATE;
    }

    public static void updateArea(ServerLevel level, ChunkAccess chunk) {
        CompassRegion compassRegion = CompassRegion.get(level, chunk.getPos());
        for (int i = 0; i < level.getSectionsCount(); ++i) {
            CompassService.updateArea(compassRegion, chunk, i);
        }
    }

    public static void notifyBlockChange(ServerLevel level, BlockPos pos) {
        ChunkAccess chunk = level.getChunk(pos);
        CompassRegion compassRegion = CompassRegion.get(level, chunk.getPos());
        CompassService.updateArea(compassRegion, chunk, level.getSectionIndex(pos.getY()));
    }

    private static void updateArea(CompassRegion compassRegion, ChunkAccess chunk, int sectionIndex) {
        int cx = chunk.getPos().x;
        int cz = chunk.getPos().z;
        LevelChunkSection section = chunk.getSections()[sectionIndex];
        if (section.hasOnlyAir()) {
            compassRegion.setHasSkyStone(cx, cz, sectionIndex, false);
            return;
        }
        BlockState desiredState = AEBlocks.MYSTERIOUS_CUBE.block().defaultBlockState();
        AtomicInteger blockCount = new AtomicInteger(0);
        section.getStates().count((state, count) -> {
            if (state == desiredState) {
                blockCount.getAndIncrement();
            }
        });
        compassRegion.setHasSkyStone(cx, cz, sectionIndex, blockCount.get() > 0);
    }

    private static int dist(int ax, int az, int bx, int bz) {
        int up = (bz - az) * 16;
        int side = (bx - ax) * 16;
        return up * up + side * side;
    }

    private static double rad(int ax, int az, int bx, int bz) {
        int up = bz - az;
        int side = bx - ax;
        return Math.atan2(-up, side) - 1.5707963267948966;
    }

    public record DirectionQuery(ServerLevel level, int cx, int cz, int maxRange) {
    }

    public record Result(boolean hasResult, boolean spin, double radians, double distance) {
        public static final Result ON_THE_SPOT = new Result(true, true, -999.0, 0.0);
        public static final Result INDETERMINATE = new Result(false, true, -999.0, 999.0);
    }
}

