/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testworld;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IPart;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.hooks.ticking.TickHandler;
import appeng.me.helpers.IGridConnectedBlockEntity;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

final class GridInitHelper {
    GridInitHelper() {
    }

    static void doAfterGridInit(final ServerLevel level, final BlockPos pos, final boolean waitForActive, final BiConsumer<IGrid, IGridNode> consumer) {
        Runnable delayedAction = new Runnable(){
            private int attempts = 120;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                BlockEntity be = level.getBlockEntity(pos);
                IGridNode gridNode = null;
                if (be instanceof IGridConnectedBlockEntity) {
                    IGridConnectedBlockEntity host = (IGridConnectedBlockEntity)be;
                    gridNode = host.getMainNode().getNode();
                } else {
                    if (!(be instanceof CableBusBlockEntity)) return;
                    CableBusBlockEntity cableBus = (CableBusBlockEntity)be;
                    IPart centerPart = cableBus.getCableBus().getPart(null);
                    if (centerPart == null) return;
                    gridNode = centerPart.getGridNode();
                }
                if (gridNode == null || waitForActive && !gridNode.isActive()) {
                    if (--this.attempts <= 0) throw new IllegalStateException("Couldn't access grid node @ " + pos);
                    TickHandler.instance().addCallable((LevelAccessor)level, this);
                    return;
                } else {
                    consumer.accept(gridNode.getGrid(), gridNode);
                }
            }
        };
        TickHandler.instance().addCallable((LevelAccessor)level, delayedAction);
    }
}

