/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import com.google.gson.JsonParseException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public final class CustomNameUtil {
    private CustomNameUtil() {
    }

    public static void setCustomName(CompoundTag tag, @Nullable String name) {
        if (name == null || name.isEmpty()) {
            CustomNameUtil.setCustomName(tag, (Component)null);
        } else {
            CustomNameUtil.setCustomName(tag, (Component)Component.literal((String)name));
        }
    }

    public static void setCustomName(CompoundTag tag, @Nullable Component name) {
        if (name == null) {
            tag.remove("display");
        } else {
            CompoundTag display = new CompoundTag();
            display.putString("Name", Component.Serializer.toJson((Component)name));
            tag.put("display", (Tag)display);
        }
    }

    @Nullable
    public static Component getCustomName(CompoundTag tag) {
        if (!tag.contains("display", 10)) {
            return null;
        }
        CompoundTag compoundTag = tag.getCompound("display");
        if (compoundTag.contains("Name", 8)) {
            try {
                MutableComponent component = Component.Serializer.fromJson((String)compoundTag.getString("Name"));
                if (component != null) {
                    return component;
                }
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return null;
    }
}

