/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.api;

import java.io.Serializable;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Frequency
implements INBTSerializable<CompoundTag> {
    private UUID owner;
    private String ownerText;
    private int channel;

    public Frequency() {
        this(1);
    }

    public Frequency(int channel) {
        this(null, channel);
    }

    public Frequency(@Nullable Player player, int channel) {
        if (player == null) {
            this.owner = null;
            this.ownerText = "public";
        } else {
            this.owner = player.getUUID();
            this.ownerText = player.getName().getString();
        }
        this.channel = channel;
    }

    private Frequency(String ownerText, @Nullable UUID owner, int channel) {
        this.ownerText = ownerText;
        this.owner = owner;
        this.channel = channel;
    }

    public Frequency(CompoundTag tagCompound) {
        this.deserializeNBT(tagCompound);
    }

    public static Frequency readFromPacket(FriendlyByteBuf buf) {
        return new Frequency(buf.readUtf(), buf.readBoolean() ? buf.readUUID() : null, buf.readVarInt());
    }

    public Frequency set(Frequency frequency) {
        this.ownerText = frequency.ownerText;
        this.owner = frequency.owner;
        this.channel = frequency.channel;
        return this;
    }

    public Frequency copy() {
        return new Frequency(this.ownerText, this.owner, this.channel);
    }

    public Frequency setPublic() {
        this.owner = null;
        this.ownerText = "public";
        return this;
    }

    public UUID getOwnerUUID() {
        return this.owner;
    }

    public String getOwner() {
        return this.ownerText;
    }

    public Frequency setOwner(@NotNull Player player) {
        this.owner = player.getUUID();
        this.ownerText = player.getName().getString();
        return this;
    }

    public int getChannel() {
        return this.channel;
    }

    public Frequency setChannel(int channel) {
        this.channel = channel;
        return this;
    }

    public boolean hasOwner() {
        return !this.ownerText.equals("public") && this.owner != null;
    }

    public String toString() {
        return "owner=" + (Serializable)(this.hasOwner() ? this.owner : "public") + ",channel=" + this.channel;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Frequency)) {
            return false;
        }
        Frequency f = (Frequency)obj;
        if (f.hasOwner()) {
            return f.channel == this.channel && f.owner.equals(this.owner) && f.ownerText.equals(this.ownerText);
        }
        return f.channel == this.channel && f.ownerText.equals(this.ownerText);
    }

    public void writeToPacket(FriendlyByteBuf buf) {
        buf.writeUtf(this.ownerText);
        buf.writeBoolean(this.hasOwner());
        if (this.hasOwner()) {
            buf.writeUUID(this.owner);
        }
        buf.writeVarInt(this.channel);
    }

    public boolean canAccess(@NotNull Player player) {
        if (!this.hasOwner()) {
            return true;
        }
        return this.getOwnerUUID().equals(player.getUUID());
    }

    public CompoundTag serializeNBT() {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.putString("ownerText", this.ownerText);
        if (this.hasOwner()) {
            tagCompound.putUUID("owner", this.owner);
        }
        tagCompound.putInt("channel", this.channel);
        return tagCompound;
    }

    public void deserializeNBT(CompoundTag tagCompound) {
        this.ownerText = tagCompound.getString("ownerText");
        this.owner = !this.ownerText.equals("public") ? tagCompound.getUUID("owner") : null;
        this.channel = tagCompound.getInt("channel");
    }
}

