/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.blockentities;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.blockentities.BlockEntityFrequencyOwner;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.menu.DimChestMenu;
import edivad.dimstorage.setup.Registration;
import edivad.dimstorage.storage.DimChestStorage;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

public class BlockEntityDimChest
extends BlockEntityFrequencyOwner {
    private static final float MIN_MOVABLE_POSITION = 0.0f;
    private static final float MAX_MOVABLE_POSITION = 0.5f;
    private static final float OPENING_SPEED = 0.05f;
    public float movablePartState = 0.0f;
    public int rotation;
    private int openCount;

    public BlockEntityDimChest(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends BlockEntityFrequencyOwner>)((BlockEntityType)Registration.DIMCHEST_TILE.get()), pos, state);
    }

    @Override
    public void onServerTick(Level level, BlockPos pos, BlockState state) {
        if (level.getGameTime() % 20L == 0L || this.openCount != this.getStorage().getNumOpen()) {
            this.openCount = this.getStorage().getNumOpen();
            level.blockEvent(pos, state.getBlock(), 1, this.openCount);
            level.updateNeighborsAt(this.worldPosition, state.getBlock());
        }
        this.commonTick();
    }

    @Override
    public void onClientTick(Level level, BlockPos pos, BlockState state) {
        this.commonTick();
    }

    private void commonTick() {
        this.movablePartState = this.openCount > 0 ? (this.movablePartState < 0.5f ? (this.movablePartState += 0.05f) : 0.5f) : (this.movablePartState > 0.0f ? (this.movablePartState -= 0.05f) : 0.0f);
    }

    public int getComparatorInput() {
        return Optional.ofNullable(this.getItemHandler(null)).map(ItemHandlerHelper::calcRedstoneFromInventory).orElse(0);
    }

    @Nullable
    public IItemHandler getItemHandler(Direction direction) {
        return this.locked ? null : new InvWrapper((Container)this.getStorage());
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.openCount = type;
            return true;
        }
        return false;
    }

    @Override
    public DimChestStorage getStorage() {
        return (DimChestStorage)DimStorageManager.instance(this.level).getStorage(this.getFrequency(), "item");
    }

    public void onPlaced(LivingEntity entity) {
        this.rotation = (int)Math.floor((double)(entity.getYRot() * 4.0f / 360.0f) + 2.5) & 3;
    }

    @Override
    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putByte("rot", (byte)this.rotation);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.rotation = tag.getByte("rot") & 3;
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag root = new CompoundTag();
        root.put("frequency", (Tag)this.getFrequency().serializeNBT());
        root.putBoolean("locked", this.locked);
        root.putByte("rot", (byte)this.rotation);
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.getTag();
        this.setFrequency(new Frequency(tag.getCompound("frequency")));
        this.locked = tag.getBoolean("locked");
        this.rotation = tag.getByte("rot") & 3;
    }

    @Override
    public CompoundTag getUpdateTag() {
        CompoundTag tag = super.getUpdateTag();
        tag.putByte("rot", (byte)this.rotation);
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.rotation = tag.getByte("rot") & 3;
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new DimChestMenu(id, inventory, this, false);
    }
}

