/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.blockentities;

import edivad.dimstorage.api.AbstractDimStorage;
import edivad.dimstorage.api.Frequency;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BlockEntityFrequencyOwner
extends BlockEntity
implements MenuProvider {
    private final Frequency frequency = new Frequency();
    public boolean locked = false;
    private int changeCount;

    public BlockEntityFrequencyOwner(BlockEntityType<? extends BlockEntityFrequencyOwner> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BlockEntityFrequencyOwner blockentity) {
        if (blockentity.getStorage().getChangeCount() > blockentity.changeCount) {
            level.updateNeighbourForOutputSignal(blockentity.worldPosition, blockentity.getBlockState().getBlock());
            blockentity.changeCount = blockentity.getStorage().getChangeCount();
        }
        blockentity.onServerTick(level, pos, state);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BlockEntityFrequencyOwner blockentity) {
        blockentity.onClientTick(level, pos, state);
    }

    public Frequency getFrequency() {
        return this.frequency.copy();
    }

    public void setFrequency(Frequency frequency) {
        this.frequency.set(frequency);
        this.setChanged();
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
    }

    public void swapOwner(Player player) {
        if (this.frequency.hasOwner()) {
            this.setFrequency(this.getFrequency().setPublic());
        } else {
            this.setFrequency(this.getFrequency().setOwner(player));
        }
    }

    public void swapLocked() {
        this.locked = !this.locked;
        this.setChanged();
    }

    public boolean canAccess(Player player) {
        return this.frequency.canAccess(player);
    }

    public abstract AbstractDimStorage getStorage();

    public abstract void onServerTick(Level var1, BlockPos var2, BlockState var3);

    public abstract void onClientTick(Level var1, BlockPos var2, BlockState var3);

    public void load(CompoundTag tag) {
        super.load(tag);
        this.frequency.set(new Frequency(tag.getCompound("frequency")));
        this.locked = tag.getBoolean("locked");
    }

    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("frequency", (Tag)this.frequency.serializeNBT());
        tag.putBoolean("locked", this.locked);
    }

    public InteractionResult use(ServerPlayer player, Level level, BlockPos pos, InteractionHand hand) {
        if (this.canAccess((Player)player)) {
            player.openMenu((MenuProvider)this, buf -> buf.writeBlockPos(this.getBlockPos()).writeBoolean(false));
        } else {
            player.displayClientMessage((Component)Component.literal((String)"Access Denied!").withStyle(ChatFormatting.RED), false);
        }
        return InteractionResult.SUCCESS;
    }

    public CompoundTag getUpdateTag() {
        CompoundTag tag = super.getUpdateTag();
        tag.put("frequency", (Tag)this.frequency.serializeNBT());
        tag.putBoolean("locked", this.locked);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.setFrequency(new Frequency(tag.getCompound("frequency")));
        this.locked = tag.getBoolean("locked");
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }
}

