/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.blocks;

import edivad.dimstorage.blockentities.BlockEntityDimChest;
import edivad.dimstorage.blockentities.BlockEntityFrequencyOwner;
import edivad.dimstorage.blocks.DimBlockBase;
import edivad.dimstorage.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class DimChest
extends DimBlockBase {
    public DimChest() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).requiresCorrectToolForDrops().strength(3.5f).noOcclusion());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockEntityDimChest(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return DimChest.createDimBlockTicker(level, blockEntityType, (BlockEntityType<? extends BlockEntityFrequencyOwner>)((BlockEntityType)Registration.DIMCHEST_TILE.get()));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof BlockEntityDimChest) {
                BlockEntityDimChest chest = (BlockEntityDimChest)blockEntity;
                if (!player.isCrouching()) {
                    return chest.use(serverPlayer, level, pos, hand);
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.getBlockEntity(pos, (BlockEntityType)Registration.DIMCHEST_TILE.get()).ifPresent(chest -> chest.onPlaced(placer));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return level.getBlockEntity(pos, (BlockEntityType)Registration.DIMCHEST_TILE.get()).map(BlockEntityDimChest::getComparatorInput).orElse(0);
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int eventID, int eventParam) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        return blockentity != null && blockentity.triggerEvent(eventID, eventParam);
    }
}

