/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.edivadlib.tools.utils.FluidUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class DimTankRenderer
implements BlockEntityRenderer<BlockEntityDimTank> {
    private static final float TANK_THICKNESS = 0.1f;

    public DimTankRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntityDimTank blockentity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (blockentity.isRemoved() || blockentity.liquidState.clientLiquid == null) {
            return;
        }
        poseStack.pushPose();
        this.renderFluid(blockentity, poseStack, bufferIn);
        poseStack.popPose();
    }

    private void renderFluid(BlockEntityDimTank blockentity, PoseStack poseStack, MultiBufferSource bufferIn) {
        FluidStack fluid = blockentity.liquidState.clientLiquid;
        float scale = 0.84999996f * (float)fluid.getAmount() / 16000.0f;
        if (scale > 0.0f) {
            Matrix4f matrix4f = poseStack.last().pose();
            TextureAtlasSprite sprite = FluidUtils.getFluidTexture((FluidStack)fluid);
            if (sprite == null) {
                return;
            }
            VertexConsumer renderer = bufferIn.getBuffer(RenderType.text((ResourceLocation)sprite.atlasLocation()));
            float u1 = sprite.getU0();
            float v1 = sprite.getV0();
            float u2 = sprite.getU1();
            float v2 = sprite.getV1();
            float margin = 0.9f;
            float offset = 0.1f;
            int color = FluidUtils.getLiquidColorWithBiome((FluidStack)fluid, (BlockEntity)blockentity);
            float r = FluidUtils.getRed((int)color);
            float g = FluidUtils.getGreen((int)color);
            float b = FluidUtils.getBlue((int)color);
            float a = FluidUtils.getAlpha((int)color);
            int light = 0xF000F0;
            renderer.vertex(matrix4f, 0.1f + offset, scale + 0.1f, 0.1f + offset).color(r, g, b, a).uv(u1, v1).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, 0.1f + offset, scale + 0.1f, margin - 0.1f).color(r, g, b, a).uv(u1, v2).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, margin - 0.1f, scale + 0.1f, margin - 0.1f).color(r, g, b, a).uv(u2, v2).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, margin - 0.1f, scale + 0.1f, 0.1f + offset).color(r, g, b, a).uv(u2, v1).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, margin - 0.1f, 0.1f, 0.1f + offset).color(r, g, b, a).uv(u2, v1).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, margin - 0.1f, 0.1f, margin - 0.1f).color(r, g, b, a).uv(u2, v2).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, 0.1f + offset, 0.1f, margin - 0.1f).color(r, g, b, a).uv(u1, v2).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, 0.1f + offset, 0.1f, 0.1f + offset).color(r, g, b, a).uv(u1, v1).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, 0.1f + offset, scale + 0.1f, margin - 0.1f).color(r, g, b, a).uv(u1, v1).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, 0.1f + offset, 0.1f, margin - 0.1f).color(r, g, b, a).uv(u1, v2).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, margin - 0.1f, 0.1f, margin - 0.1f).color(r, g, b, a).uv(u2, v2).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, margin - 0.1f, scale + 0.1f, margin - 0.1f).color(r, g, b, a).uv(u2, v1).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, margin - 0.1f, scale + 0.1f, 0.1f + offset).color(r, g, b, a).uv(u2, v1).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, margin - 0.1f, 0.1f, 0.1f + offset).color(r, g, b, a).uv(u2, v2).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, 0.1f + offset, 0.1f, 0.1f + offset).color(r, g, b, a).uv(u1, v2).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, 0.1f + offset, scale + 0.1f, 0.1f + offset).color(r, g, b, a).uv(u1, v1).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, margin - 0.1f, scale + 0.1f, margin - 0.1f).color(r, g, b, a).uv(u2, v1).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, margin - 0.1f, 0.1f, margin - 0.1f).color(r, g, b, a).uv(u2, v2).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, margin - 0.1f, 0.1f, 0.1f + offset).color(r, g, b, a).uv(u1, v2).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, margin - 0.1f, scale + 0.1f, 0.1f + offset).color(r, g, b, a).uv(u1, v1).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, 0.1f + offset, scale + 0.1f, 0.1f + offset).color(r, g, b, a).uv(u1, v1).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, 0.1f + offset, 0.1f, 0.1f + offset).color(r, g, b, a).uv(u1, v2).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, 0.1f + offset, 0.1f, margin - 0.1f).color(r, g, b, a).uv(u2, v2).uv2(0xF000F0).endVertex();
            renderer.vertex(matrix4f, 0.1f + offset, scale + 0.1f, margin - 0.1f).color(r, g, b, a).uv(u2, v1).uv2(0xF000F0).endVertex();
        }
    }
}

