/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.screen.element.button;

import edivad.dimstorage.blockentities.BlockEntityDimChest;
import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.dimstorage.blockentities.BlockEntityFrequencyOwner;
import edivad.dimstorage.network.PacketHandler;
import edivad.dimstorage.network.to_server.UpdateDimChest;
import edivad.dimstorage.network.to_server.UpdateDimTank;
import edivad.dimstorage.setup.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class OwnerButton
extends AbstractButton {
    private final BlockEntityFrequencyOwner owner;

    public OwnerButton(int width, int height, BlockEntityFrequencyOwner owner) {
        super(width, height, 64, 20, OwnerButton.getText(owner));
        this.owner = owner;
        this.active = (Boolean)Config.DimBlock.ALLOW_PRIVATE_NETWORK.get();
    }

    private static Component getText(BlockEntityFrequencyOwner owner) {
        return Component.literal((String)owner.getFrequency().getOwner());
    }

    public void onPress() {
        this.owner.swapOwner((Player)Minecraft.getInstance().player);
        BlockEntityFrequencyOwner blockEntityFrequencyOwner = this.owner;
        if (blockEntityFrequencyOwner instanceof BlockEntityDimChest) {
            BlockEntityDimChest chest = (BlockEntityDimChest)blockEntityFrequencyOwner;
            PacketHandler.sendToServer(new UpdateDimChest(chest));
        } else {
            blockEntityFrequencyOwner = this.owner;
            if (blockEntityFrequencyOwner instanceof BlockEntityDimTank) {
                BlockEntityDimTank tank = (BlockEntityDimTank)blockEntityFrequencyOwner;
                PacketHandler.sendToServer(new UpdateDimTank(tank));
            }
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }
}

