/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.screen.pattern;

import edivad.dimstorage.blockentities.BlockEntityDimChest;
import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.dimstorage.blockentities.BlockEntityFrequencyOwner;
import edivad.dimstorage.client.screen.element.button.ChangeButton;
import edivad.dimstorage.client.screen.element.button.LockButton;
import edivad.dimstorage.client.screen.element.button.OwnerButton;
import edivad.dimstorage.client.screen.element.textfield.FrequencyText;
import edivad.dimstorage.client.screen.pattern.PanelScreen;
import edivad.dimstorage.network.PacketHandler;
import edivad.dimstorage.network.to_server.UpdateDimChest;
import edivad.dimstorage.network.to_server.UpdateDimTank;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class FrequencyScreen<T extends AbstractContainerMenu>
extends PanelScreen<T> {
    private static final Component OWNER = Component.translatable((String)"gui.dimstorage.owner");
    private static final Component FREQ = Component.translatable((String)"gui.dimstorage.frequency");
    private static final Component LOCKED = Component.translatable((String)"gui.dimstorage.locked");
    protected BlockEntityFrequencyOwner blockEntityFrequencyOwner;
    private FrequencyText freqTextField;

    public FrequencyScreen(T container, BlockEntityFrequencyOwner blockEntityFrequencyOwner, Inventory inventory, Component text, ResourceLocation background, boolean drawSettings) {
        super(container, inventory, text, background, drawSettings);
        this.blockEntityFrequencyOwner = blockEntityFrequencyOwner;
    }

    protected void init() {
        super.init();
        this.clearComponent();
        this.addComponent((AbstractWidget)new OwnerButton(this.width / 2 + 95, this.height / 2 - 53, this.blockEntityFrequencyOwner));
        this.addComponent((AbstractWidget)new ChangeButton(this.width / 2 + 95, this.height / 2 + 7, b -> this.changeFrequency()));
        this.addComponent((AbstractWidget)new LockButton(this.width / 2 + 95, this.height / 2 + 46, this.blockEntityFrequencyOwner));
        this.freqTextField = new FrequencyText(this.width / 2 + 95, this.height / 2 - 12, this.blockEntityFrequencyOwner.getFrequency());
        this.addComponent((AbstractWidget)this.freqTextField);
        this.drawSettings(this.drawSettings);
    }

    private void changeFrequency() {
        int prevChannel = this.blockEntityFrequencyOwner.getFrequency().getChannel();
        try {
            int newFreq = Math.abs(Integer.parseInt(this.freqTextField.getValue()));
            this.blockEntityFrequencyOwner.setFrequency(this.blockEntityFrequencyOwner.getFrequency().setChannel(newFreq));
            BlockEntityFrequencyOwner blockEntityFrequencyOwner = this.blockEntityFrequencyOwner;
            if (blockEntityFrequencyOwner instanceof BlockEntityDimChest) {
                BlockEntityDimChest chest = (BlockEntityDimChest)blockEntityFrequencyOwner;
                PacketHandler.sendToServer(new UpdateDimChest(chest));
            } else {
                blockEntityFrequencyOwner = this.blockEntityFrequencyOwner;
                if (blockEntityFrequencyOwner instanceof BlockEntityDimTank) {
                    BlockEntityDimTank tank = (BlockEntityDimTank)blockEntityFrequencyOwner;
                    PacketHandler.sendToServer(new UpdateDimTank(tank));
                }
            }
        }
        catch (Exception e) {
            this.freqTextField.setValue(String.valueOf(prevChannel));
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.freqTextField.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        this.freqTextField.mouseClicked(mouseX, mouseY, clickedButton);
        return super.mouseClicked(mouseX, mouseY, clickedButton);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        if (this.drawSettings) {
            int posY = 45;
            guiGraphics.drawString(this.font, OWNER, 185, posY, 0x404040, false);
            guiGraphics.hLine(185, 185 + this.font.width((FormattedText)OWNER), posY += 9, -13421773);
            guiGraphics.drawString(this.font, FREQ, 185, posY += 31, 0x404040, false);
            guiGraphics.hLine(185, 185 + this.font.width((FormattedText)FREQ), posY += 9, -13421773);
            guiGraphics.drawString(this.font, LOCKED, 185, posY += 50, 0x404040, false);
            guiGraphics.hLine(185, 185 + this.font.width((FormattedText)LOCKED), posY += 9, -13421773);
        }
    }
}

