/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.items;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.blockentities.BlockEntityFrequencyOwner;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ItemDimBase
extends BlockItem {
    public ItemDimBase(Block block, Item.Properties properties) {
        super(block, properties);
    }

    private Frequency getFreq(ItemStack stack) {
        CompoundTag stackTag;
        if (stack.hasTag() && (stackTag = stack.getTagElement("dimstorage")) != null && stackTag.contains("frequency")) {
            return new Frequency(stackTag.getCompound("frequency"));
        }
        return new Frequency();
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        if (super.placeBlock(context, state)) {
            Level level = context.getLevel();
            BlockPos pos = context.getClickedPos();
            ItemStack stack = context.getItemInHand();
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof BlockEntityFrequencyOwner) {
                BlockEntityFrequencyOwner b = (BlockEntityFrequencyOwner)blockEntity;
                b.setFrequency(this.getFreq(stack));
                return true;
            }
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        Frequency frequency = this.getFreq(stack);
        if (frequency.hasOwner()) {
            tooltip.add((Component)Component.translatable((String)"gui.dimstorage.owner").append(" " + frequency.getOwner()).withStyle(ChatFormatting.DARK_RED));
        }
        if (stack.hasTag()) {
            tooltip.add((Component)Component.translatable((String)"gui.dimstorage.frequency").append(" " + frequency.getChannel()));
        }
    }
}

