/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.manager;

import edivad.dimstorage.DimStorage;
import edivad.dimstorage.api.AbstractDimStorage;
import edivad.dimstorage.api.DimStoragePlugin;
import edivad.dimstorage.api.Frequency;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

public class DimStorageManager
extends SavedData {
    private static final String DATA_TAG = "dimstorage.inventories";
    private static final HashMap<String, DimStoragePlugin> PLUGINS = new HashMap();
    private static DimStorageManager SERVER_MANAGER;
    private static DimStorageManager CLIENT_MANAGER;
    private final boolean client;
    private final Map<String, AbstractDimStorage> storageMap;
    private final Map<String, List<AbstractDimStorage>> storageList;
    private final List<AbstractDimStorage> dirtyStorage;
    private CompoundTag saveTag;

    private DimStorageManager(Level level) {
        this.client = level.isClientSide();
        this.saveTag = new CompoundTag();
        this.storageMap = Collections.synchronizedMap(new HashMap());
        this.storageList = Collections.synchronizedMap(new HashMap());
        this.dirtyStorage = Collections.synchronizedList(new LinkedList());
        for (String key : PLUGINS.keySet()) {
            this.storageList.put(key, new ArrayList());
        }
    }

    public static void reloadManager(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SERVER_MANAGER = DimStorageManager.get(serverLevel);
        } else {
            CLIENT_MANAGER = new DimStorageManager(level);
        }
    }

    public static DimStorageManager instance(Level level) {
        DimStorageManager manager;
        boolean client = level.isClientSide();
        DimStorageManager dimStorageManager = manager = client ? CLIENT_MANAGER : SERVER_MANAGER;
        if (manager == null) {
            DimStorageManager.reloadManager(level);
            manager = client ? CLIENT_MANAGER : SERVER_MANAGER;
        }
        return manager;
    }

    private static DimStorageManager get(ServerLevel level) {
        return (DimStorageManager)level.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new DimStorageManager((Level)level), tag -> {
            DimStorageManager manager = new DimStorageManager((Level)level);
            manager.load((CompoundTag)tag);
            return manager;
        }), DATA_TAG);
    }

    public static void registerPlugin(DimStoragePlugin plugin) {
        PLUGINS.put(plugin.identifier(), plugin);
        if (SERVER_MANAGER != null) {
            DimStorageManager.SERVER_MANAGER.storageList.put(plugin.identifier(), new ArrayList());
        }
        if (CLIENT_MANAGER != null) {
            DimStorageManager.CLIENT_MANAGER.storageList.put(plugin.identifier(), new ArrayList());
        }
    }

    public boolean isServer() {
        return !this.client;
    }

    private void sendClientInfo(Player player) {
        for (Map.Entry<String, DimStoragePlugin> plugin : PLUGINS.entrySet()) {
            plugin.getValue().sendClientInfo(player, this.storageList.get(plugin.getKey()));
        }
    }

    public CompoundTag save(CompoundTag tag) {
        for (AbstractDimStorage inv : this.dirtyStorage) {
            this.saveTag.put(DimStorageManager.buildKey(inv.freq, inv.type()), (Tag)inv.saveToTag());
            inv.setClean();
        }
        this.dirtyStorage.clear();
        tag.put("inventory", (Tag)this.saveTag);
        return tag;
    }

    private void load(CompoundTag tag) {
        this.saveTag = tag.getCompound("inventory");
    }

    private static String buildKey(Frequency frequency, String type) {
        return frequency + ",type=" + type;
    }

    public AbstractDimStorage getStorage(Frequency freq, String type) {
        String key = DimStorageManager.buildKey(freq, type);
        AbstractDimStorage storage = this.storageMap.get(key);
        if (storage == null) {
            storage = PLUGINS.get(type).createDimStorage(this, freq);
            if (!this.client && this.saveTag.contains(key)) {
                storage.loadFromTag(this.saveTag.getCompound(key));
            }
            this.storageMap.put(key, storage);
            this.storageList.get(type).add(storage);
        }
        return storage;
    }

    public void requestSave(AbstractDimStorage storage) {
        this.dirtyStorage.add(storage);
        this.setDirty();
    }

    public static class DimStorageSaveHandler {
        @SubscribeEvent
        public void onWorldLoad(LevelEvent.Load event) {
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof Level) {
                Level level = (Level)levelAccessor;
                DimStorageManager.reloadManager(level);
            } else {
                DimStorage.LOGGER.warn("Unable to reload the manager");
            }
        }

        @SubscribeEvent
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            DimStorageManager.instance(event.getEntity().level()).sendClientInfo(event.getEntity());
        }

        @SubscribeEvent
        public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            DimStorageManager.instance(event.getEntity().level()).sendClientInfo(event.getEntity());
        }
    }
}

