/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.network;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.storage.DimTankStorage;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public abstract class TankState {
    public FluidStack clientLiquid = FluidStack.EMPTY;
    public FluidStack serverLiquid = FluidStack.EMPTY;
    private Frequency frequency;

    public TankState(Frequency frequency) {
        this.frequency = frequency;
    }

    public void setFrequency(Frequency frequency) {
        this.frequency = frequency;
    }

    public void update(Level level) {
        FluidStack succ;
        FluidStack prec;
        if (level.isClientSide()) {
            prec = this.clientLiquid.copy();
            succ = this.clientLiquid = this.serverLiquid.copy();
        } else {
            prec = this.serverLiquid.copy();
            succ = this.serverLiquid = this.getFluidStorageServer((ServerLevel)level);
            this.sendSyncPacket();
            this.clientLiquid = this.serverLiquid.copy();
        }
        if (prec.getAmount() == 0 != (succ.getAmount() == 0) || !prec.isFluidEqual(succ)) {
            this.onLiquidChanged();
        }
    }

    public void onLiquidChanged() {
    }

    public abstract void sendSyncPacket();

    public void sync(FluidStack liquid) {
        this.serverLiquid = liquid;
    }

    private FluidStack getFluidStorageServer(ServerLevel level) {
        return ((DimTankStorage)DimStorageManager.instance((Level)level).getStorage(this.frequency, "fluid")).getFluidInTank(0);
    }
}

