/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.network.to_client;

import edivad.dimstorage.DimStorage;
import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.edivadlib.network.EdivadLibPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record SyncLiquidTank(BlockPos pos, FluidStack fluidStack) implements EdivadLibPacket
{
    public static final ResourceLocation ID = DimStorage.rl("sync_liquid_tank");

    public static SyncLiquidTank read(FriendlyByteBuf buf) {
        return new SyncLiquidTank(buf.readBlockPos(), buf.readFluidStack());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeFluidStack(this.fluidStack);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.level().ifPresent(level -> {
            BlockEntity patt1109$temp;
            if (level.isLoaded(this.pos) && (patt1109$temp = level.getBlockEntity(this.pos)) instanceof BlockEntityDimTank) {
                BlockEntityDimTank tank = (BlockEntityDimTank)patt1109$temp;
                tank.liquidState.sync(this.fluidStack);
            }
        });
    }
}

