/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.network.to_server;

import edivad.dimstorage.DimStorage;
import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.blockentities.BlockEntityDimChest;
import edivad.dimstorage.setup.Registration;
import edivad.edivadlib.network.EdivadLibPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record UpdateDimChest(BlockPos pos, Frequency freq, boolean locked) implements EdivadLibPacket
{
    public static final ResourceLocation ID = DimStorage.rl("update_dim_chest");

    public UpdateDimChest(BlockEntityDimChest tank) {
        this(tank.getBlockPos(), tank.getFrequency(), tank.locked);
    }

    public static UpdateDimChest read(FriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        Frequency freq = Frequency.readFromPacket(buf);
        boolean locked = buf.readBoolean();
        return new UpdateDimChest(pos, freq, locked);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        this.freq.writeToPacket(buf);
        buf.writeBoolean(this.locked);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> {
            Level level = player.level();
            level.getBlockEntity(this.pos, (BlockEntityType)Registration.DIMCHEST_TILE.get()).ifPresent(chest -> {
                chest.setFrequency(this.freq);
                chest.locked = this.locked;
                chest.setChanged();
                level.sendBlockUpdated(this.pos, chest.getBlockState(), chest.getBlockState(), 3);
                player.openMenu((MenuProvider)chest, buf -> buf.writeBlockPos(this.pos).writeBoolean(true));
            });
        });
    }
}

