/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.network.to_server;

import edivad.dimstorage.DimStorage;
import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.edivadlib.network.EdivadLibPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record UpdateDimTank(BlockPos pos, Frequency freq, boolean locked, boolean autoEject) implements EdivadLibPacket
{
    public static final ResourceLocation ID = DimStorage.rl("update_dim_tank");

    public UpdateDimTank(BlockEntityDimTank tank) {
        this(tank.getBlockPos(), tank.getFrequency(), tank.locked, tank.autoEject);
    }

    public static UpdateDimTank read(FriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        Frequency freq = Frequency.readFromPacket(buf);
        boolean locked = buf.readBoolean();
        boolean autoEject = buf.readBoolean();
        return new UpdateDimTank(pos, freq, locked, autoEject);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        this.freq.writeToPacket(buf);
        buf.writeBoolean(this.locked);
        buf.writeBoolean(this.autoEject);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> {
            Level level = player.level();
            BlockEntity patt1513$temp = level.getBlockEntity(this.pos);
            if (patt1513$temp instanceof BlockEntityDimTank) {
                BlockEntityDimTank tank = (BlockEntityDimTank)patt1513$temp;
                tank.setFrequency(this.freq);
                tank.locked = this.locked;
                tank.autoEject = this.autoEject;
                tank.setChanged();
                level.sendBlockUpdated(this.pos, tank.getBlockState(), tank.getBlockState(), 3);
                player.openMenu((MenuProvider)tank, buf -> buf.writeBlockPos(this.pos).writeBoolean(true));
            }
        });
    }
}

