/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.tools;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class InventoryUtils {
    public static void readItemStacksFromTag(ItemStack[] items, ListTag tagList) {
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag tag = tagList.getCompound(i);
            short b = tag.getShort("Slot");
            items[b] = ItemStack.of((CompoundTag)tag);
            Tag quant = tag.get("Quantity");
            if (!(quant instanceof NumericTag)) continue;
            NumericTag numericTag = (NumericTag)quant;
            items[b].setCount(numericTag.getAsInt());
        }
    }

    public static ListTag writeItemStacksToTag(ItemStack[] items) {
        return InventoryUtils.writeItemStacksToTag(items, 64);
    }

    public static ListTag writeItemStacksToTag(ItemStack[] items, int maxQuantity) {
        ListTag tagList = new ListTag();
        for (int i = 0; i < items.length; ++i) {
            CompoundTag tag = new CompoundTag();
            tag.putShort("Slot", (short)i);
            items[i].save(tag);
            if (maxQuantity > Short.MAX_VALUE) {
                tag.putInt("Quantity", items[i].getCount());
            } else if (maxQuantity > 127) {
                tag.putShort("Quantity", (short)items[i].getCount());
            }
            tagList.add((Object)tag);
        }
        return tagList;
    }

    public static ItemStack removeStackFromSlot(Container inv, int slot) {
        ItemStack stack = inv.getItem(slot);
        inv.setItem(slot, ItemStack.EMPTY);
        return stack;
    }

    @NotNull
    public static ItemStack decrStackSize(Container inv, int slot, int size) {
        ItemStack item = inv.getItem(slot);
        if (!item.isEmpty()) {
            if (item.getCount() <= size) {
                inv.setItem(slot, ItemStack.EMPTY);
                inv.setChanged();
                return item;
            }
            ItemStack itemstack1 = item.split(size);
            if (item.getCount() == 0) {
                inv.setItem(slot, ItemStack.EMPTY);
            } else {
                inv.setItem(slot, item);
            }
            inv.setChanged();
            return itemstack1;
        }
        return ItemStack.EMPTY;
    }

    public static boolean mergeItemStack(ItemStack stack, int startIndex, int endIndex, InvWrapper wrapper) {
        int i;
        boolean flag = false;
        if (stack.isStackable()) {
            for (i = startIndex; !stack.isEmpty() && i < endIndex; ++i) {
                int maxSize;
                ItemStack itemstack = wrapper.getStackInSlot(i);
                if (itemstack.isEmpty() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemstack)) continue;
                int j = itemstack.getCount() + stack.getCount();
                if (j <= (maxSize = stack.getMaxStackSize())) {
                    stack.setCount(0);
                    itemstack.setCount(j);
                    flag = true;
                    continue;
                }
                if (itemstack.getCount() >= maxSize) continue;
                stack.shrink(maxSize - itemstack.getCount());
                itemstack.setCount(maxSize);
                flag = true;
            }
        }
        if (!stack.isEmpty()) {
            for (i = startIndex; i < endIndex && !flag; ++i) {
                ItemStack itemstack1 = wrapper.getStackInSlot(i);
                if (!itemstack1.isEmpty() || !wrapper.isItemValid(i, stack)) continue;
                if (stack.getCount() > 64) {
                    wrapper.setStackInSlot(i, stack.split(64));
                } else {
                    wrapper.setStackInSlot(i, stack.split(stack.getCount()));
                }
                flag = true;
            }
        }
        return flag;
    }
}

