/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stylisheffects.client.gui.effects;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.stylisheffects.StylishEffects;
import fuzs.stylisheffects.api.v1.client.MobEffectWidgetContext;
import fuzs.stylisheffects.client.core.ClientAbstractions;
import fuzs.stylisheffects.client.gui.effects.EffectWidget;
import fuzs.stylisheffects.client.gui.effects.RenderAreasProvider;
import fuzs.stylisheffects.client.handler.EffectRendererEnvironment;
import fuzs.stylisheffects.client.util.ColorUtil;
import fuzs.stylisheffects.config.ClientConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEffectRenderer
implements EffectWidget,
RenderAreasProvider {
    public static final double DEFAULT_WIDGET_SCALE = 4.0;
    protected static final ResourceLocation EFFECT_BACKGROUND = new ResourceLocation("stylisheffects", "textures/gui/mob_effect_background.png");
    private final EffectRendererEnvironment environment;
    protected Object screen;
    private int availableWidth;
    private int availableHeight;
    private int startX;
    private int startY;
    private MobEffectWidgetContext.ScreenSide screenSide;
    protected List<MobEffectInstance> activeEffects;

    protected AbstractEffectRenderer(EffectRendererEnvironment environment) {
        this.environment = environment;
    }

    public void setScreenDimensions(Object screen, int availableWidth, int availableHeight, int startX, int startY, MobEffectWidgetContext.ScreenSide screenSide) {
        this.screen = screen;
        this.availableWidth = availableWidth;
        this.availableHeight = availableHeight;
        this.startX = startX;
        this.startY = startY;
        this.screenSide = screenSide;
        switch (this.environment) {
            case GUI: {
                this.screenSide = this.screenSide.inverse();
                this.availableWidth -= ((ClientConfig.GuiRendererConfig)this.rendererConfig()).offsetX;
                this.availableHeight -= ((ClientConfig.GuiRendererConfig)this.rendererConfig()).offsetY;
                this.startX += (this.screenSide.right() ? 1 : -1) * ((ClientConfig.GuiRendererConfig)this.rendererConfig()).offsetX;
                this.startY += ((ClientConfig.GuiRendererConfig)this.rendererConfig()).offsetY;
                break;
            }
            case INVENTORY: {
                this.availableWidth -= ((ClientConfig.InventoryRendererConfig)this.rendererConfig()).screenBorderDistance;
            }
        }
    }

    public final void setActiveEffects(Collection<MobEffectInstance> activeEffects) {
        if (activeEffects.isEmpty()) {
            this.activeEffects = null;
            return;
        }
        this.activeEffects = activeEffects.stream().filter(this::isEffectAllowedToShow).sorted().collect(Collectors.toList());
    }

    private boolean isEffectAllowedToShow(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.isInfiniteDuration() && this.rendererConfig().hideInfiniteEffects) {
            return false;
        }
        if (!mobEffectInstance.showIcon() && this.rendererConfig().respectHideParticles) {
            return false;
        }
        return ClientAbstractions.INSTANCE.isMobEffectVisibleIn(this.environment, mobEffectInstance);
    }

    public final boolean isActive() {
        return this.activeEffects != null && !this.activeEffects.isEmpty();
    }

    public final boolean isValid() {
        return !this.rendererConfig().allowFallback || this.getMaxRows() > 0 && this.getMaxColumns() > 0;
    }

    public final double getWidgetScale() {
        return this.rendererConfig().scale / 4.0;
    }

    public final int getScaledWidth() {
        return (int)((double)this.getWidth() * this.getWidgetScale());
    }

    public final int getScaledHeight() {
        return (int)((double)this.getHeight() * this.getWidgetScale());
    }

    public abstract MobEffectWidgetContext.Renderer getEffectRenderer();

    protected abstract int getBackgroundTextureX();

    protected abstract int getBackgroundTextureY();

    protected abstract int getSpriteOffsetX();

    protected abstract int getSpriteOffsetY(boolean var1);

    protected int getDurationOffsetX() {
        return this.getWidth() / 2;
    }

    protected int getDurationOffsetY() {
        return this.getHeight() - 10;
    }

    @Nullable
    public abstract EffectRendererEnvironment.Factory getFallbackRenderer();

    @Override
    public List<Rect2i> getRenderAreas() {
        return this.getEffectPositions(this.activeEffects).stream().map(Pair::getValue).map(pos -> new Rect2i(pos[0], pos[1], this.getScaledWidth(), this.getScaledHeight())).collect(Collectors.toList());
    }

    public List<Pair<MobEffectInstance, int[]>> getEffectPositions(List<MobEffectInstance> activeEffects) {
        ArrayList effectToPos = Lists.newArrayList();
        for (int counter = 0; counter < activeEffects.size(); ++counter) {
            int posX = counter % this.getMaxClampedColumns();
            int posY = counter / this.getMaxClampedColumns();
            effectToPos.add(Pair.of((Object)activeEffects.get(counter), (Object)this.coordsToEffectPosition(posX, posY)));
        }
        return effectToPos;
    }

    protected int getTopOffset() {
        return 0;
    }

    protected int[] coordsToEffectPosition(int coordX, int coordY) {
        int[] renderPositions = new int[2];
        switch (this.screenSide) {
            case LEFT: {
                renderPositions[0] = this.startX - (this.getScaledWidth() + 1) - (this.getScaledWidth() + this.rendererConfig().widgetSpaceX) * coordX;
                renderPositions[1] = this.startY + this.getTopOffset() + this.getAdjustedHeight() * coordY;
                break;
            }
            case RIGHT: {
                renderPositions[0] = this.startX + 1 + (this.getScaledWidth() + this.rendererConfig().widgetSpaceX) * coordX;
                renderPositions[1] = this.startY + this.getTopOffset() + this.getAdjustedHeight() * coordY;
            }
        }
        return renderPositions;
    }

    public void renderEffects(GuiGraphics guiGraphics, Minecraft minecraft) {
        for (Pair<MobEffectInstance, int[]> entry : this.getEffectPositions(this.activeEffects)) {
            this.renderWidget(guiGraphics, ((int[])entry.getValue())[0], ((int[])entry.getValue())[1], minecraft, (MobEffectInstance)entry.getKey());
        }
    }

    protected float getBlinkingAlpha(MobEffectInstance mobEffectInstance) {
        if (!mobEffectInstance.isAmbient() && !mobEffectInstance.isInfiniteDuration() && mobEffectInstance.getDuration() <= 200) {
            int duration = 10 - mobEffectInstance.getDuration() / 20;
            return Mth.clamp((float)((float)mobEffectInstance.getDuration() / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + Mth.cos((float)((float)mobEffectInstance.getDuration() * (float)Math.PI / 5.0f)) * Mth.clamp((float)((float)duration / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
        }
        return 1.0f;
    }

    private int getAvailableWidth() {
        return Math.min(this.availableWidth, this.rendererConfig().maxColumns * (this.getScaledWidth() + this.rendererConfig().widgetSpaceX));
    }

    private int getAvailableHeight() {
        return Math.min(this.availableHeight, this.rendererConfig().maxRows * (this.getScaledHeight() + this.rendererConfig().widgetSpaceY));
    }

    private int getMaxColumns() {
        return this.getAvailableWidth() / (this.getScaledWidth() + this.rendererConfig().widgetSpaceX);
    }

    public int getMaxClampedColumns() {
        return Mth.clamp((int)this.getMaxColumns(), (int)1, (int)this.rendererConfig().maxColumns);
    }

    private int getAdjustedHeight() {
        if (this.getRows() > this.getMaxClampedRows()) {
            return (this.getAvailableHeight() - this.getScaledHeight()) / Math.max(1, this.getRows() - 1);
        }
        return this.getScaledHeight() + this.rendererConfig().widgetSpaceY;
    }

    private int getMaxRows() {
        return this.getAvailableHeight() / (this.getScaledHeight() + this.rendererConfig().widgetSpaceY);
    }

    public int getMaxClampedRows() {
        return Mth.clamp((int)this.getMaxRows(), (int)1, (int)this.rendererConfig().maxRows);
    }

    public int getRows() {
        return this.splitByColumns(this.activeEffects.size());
    }

    protected int splitByColumns(int amountToSplit) {
        return (int)Math.ceil((float)amountToSplit / (float)this.getMaxClampedColumns());
    }

    protected ClientConfig.EffectRendererConfig rendererConfig() {
        return switch (this.environment) {
            default -> throw new IncompatibleClassChangeError();
            case EffectRendererEnvironment.INVENTORY -> ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer();
            case EffectRendererEnvironment.GUI -> ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).guiRenderer();
        };
    }

    protected abstract ClientConfig.EffectWidgetConfig widgetConfig();

    @Override
    public final void renderWidget(GuiGraphics guiGraphics, int posX, int posY, Minecraft minecraft, MobEffectInstance mobEffectInstance) {
        RenderSystem.enableBlend();
        guiGraphics.pose().pushPose();
        double scale = this.getWidgetScale();
        if (scale != 1.0) {
            guiGraphics.pose().scale((float)scale, (float)scale, 1.0f);
            posX = (int)((double)posX / scale);
            posY = (int)((double)posY / scale);
        }
        this.drawWidgetBackground(guiGraphics, posX, posY, mobEffectInstance);
        this.drawEffectSprite(guiGraphics, posX, posY, minecraft, mobEffectInstance);
        this.drawEffectText(guiGraphics, posX, posY, minecraft, mobEffectInstance);
        this.drawEffectAmplifier(guiGraphics, posX, posY, mobEffectInstance);
        guiGraphics.pose().popPose();
    }

    protected void drawWidgetBackground(GuiGraphics guiGraphics, int posX, int posY, MobEffectInstance mobEffectInstance) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)this.rendererConfig().widgetAlpha));
        int backgroundY = this.getBackgroundY(mobEffectInstance, this.widgetConfig().ambientBorder, this.widgetConfig().qualityBorder);
        guiGraphics.blit(EFFECT_BACKGROUND, posX, posY, (float)this.getBackgroundTextureX(), (float)(this.getBackgroundTextureY() + backgroundY * this.getHeight()), this.getWidth(), this.getHeight(), 256, 256);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawEffectSprite(GuiGraphics guiGraphics, int posX, int posY, Minecraft minecraft, MobEffectInstance mobEffectInstance) {
        if (this.drawCustomEffect(guiGraphics, posX, posY, mobEffectInstance)) {
            return;
        }
        float blinkingAlpha = this.widgetConfig().blinkingAlpha ? this.getBlinkingAlpha(mobEffectInstance) : 1.0f;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(blinkingAlpha * (float)this.rendererConfig().widgetAlpha));
        TextureAtlasSprite atlasSprite = minecraft.getMobEffectTextures().get(mobEffectInstance.getEffect());
        guiGraphics.blit(posX + this.getSpriteOffsetX(), posY + this.getSpriteOffsetY(!this.widgetConfig().ambientDuration && mobEffectInstance.isAmbient()), 0, 18, 18, atlasSprite);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private boolean drawCustomEffect(GuiGraphics guiGraphics, int posX, int posY, MobEffectInstance mobEffectInstance) {
        Object object = this.screen;
        if (object instanceof EffectRenderingInventoryScreen) {
            EffectRenderingInventoryScreen effectInventoryScreen = (EffectRenderingInventoryScreen)object;
            return ClientAbstractions.INSTANCE.renderInventoryIcon(mobEffectInstance, effectInventoryScreen, guiGraphics, posX, posY, 0);
        }
        object = this.screen;
        if (object instanceof Gui) {
            Gui gui = (Gui)object;
            return ClientAbstractions.INSTANCE.renderGuiIcon(mobEffectInstance, gui, guiGraphics, posX, posY, 0.0f, this.getBlinkingAlpha(mobEffectInstance) * (float)this.rendererConfig().widgetAlpha);
        }
        return false;
    }

    protected void drawEffectText(GuiGraphics guiGraphics, int posX, int posY, Minecraft minecraft, MobEffectInstance mobEffectInstance) {
        if (!this.widgetConfig().ambientDuration && mobEffectInstance.isAmbient()) {
            return;
        }
        this.getEffectDuration(mobEffectInstance).ifPresent(durationComponent -> {
            int potionColor = ColorUtil.getEffectColor(this.widgetConfig().durationColor, mobEffectInstance);
            int alpha = (int)(this.rendererConfig().widgetAlpha * 255.0) << 24;
            FormattedCharSequence text = durationComponent.getVisualOrderText();
            int offsetX = this.getDurationOffsetX();
            int offsetY = this.getDurationOffsetY();
            guiGraphics.drawString(minecraft.font, text, posX + offsetX - 1 - minecraft.font.width(text) / 2, posY + offsetY, alpha, false);
            guiGraphics.drawString(minecraft.font, text, posX + offsetX + 1 - minecraft.font.width(text) / 2, posY + offsetY, alpha, false);
            guiGraphics.drawString(minecraft.font, text, posX + offsetX - minecraft.font.width(text) / 2, posY + offsetY - 1, alpha, false);
            guiGraphics.drawString(minecraft.font, text, posX + offsetX - minecraft.font.width(text) / 2, posY + offsetY + 1, alpha, false);
            guiGraphics.drawString(minecraft.font, text, posX + offsetX - minecraft.font.width(text) / 2, posY + offsetY, alpha | potionColor, false);
        });
    }

    protected void drawEffectAmplifier(GuiGraphics guiGraphics, int posX, int posY, MobEffectInstance mobEffectInstance) {
    }

    protected int getBackgroundY(MobEffectInstance mobEffectInstance, boolean showAmbient, boolean showQuality) {
        if (showAmbient && mobEffectInstance.isAmbient()) {
            return 1;
        }
        if (showQuality) {
            return mobEffectInstance.getEffect().isBeneficial() ? 2 : 3;
        }
        return 0;
    }

    protected final Optional<Component> getEffectDuration(MobEffectInstance mobEffectInstance) {
        if (this.isInfiniteDuration(mobEffectInstance)) {
            return Optional.ofNullable(this.getInfiniteDurationString()).map(Component::literal);
        }
        return Optional.of(Component.literal((String)this.formatEffectDuration(mobEffectInstance)));
    }

    @Nullable
    protected String getInfiniteDurationString() {
        return "\u221e";
    }

    protected boolean isInfiniteDuration(MobEffectInstance mobEffectInstance) {
        return mobEffectInstance.getDuration() >= 72000 || mobEffectInstance.isInfiniteDuration();
    }

    protected String formatEffectDuration(MobEffectInstance mobEffectInstance) {
        return AbstractEffectRenderer.formatTickDuration(mobEffectInstance.getDuration());
    }

    public static String formatTickDuration(int ticks) {
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        seconds %= 60;
        int hours = minutes / 60;
        minutes %= 60;
        if (hours > 0) {
            return String.format(Locale.ROOT, "%d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format(Locale.ROOT, "%d:%02d", minutes, seconds);
    }

    public static String formatCompactTickDuration(int ticks) {
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        int hours = minutes / 60;
        int days = hours / 24;
        seconds %= 60;
        minutes %= 60;
        hours %= 24;
        if (days > 0) {
            return days + "d";
        }
        if (hours > 0) {
            return hours + "h";
        }
        if (minutes > 0) {
            return minutes + "m";
        }
        return seconds + "s";
    }

    public Optional<List<Component>> getHoveredEffectTooltip(int mouseX, int mouseY, TooltipFlag tooltipFlag) {
        if (this.environment == EffectRendererEnvironment.INVENTORY && ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().hoveringTooltip) {
            return this.getHoveredEffect(mouseX, mouseY).map(mobEffectInstance -> {
                List<Component> tooltipLines = this.makeEffectTooltip((MobEffectInstance)mobEffectInstance, ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().tooltipDuration);
                ClientAbstractions.INSTANCE.onGatherEffectTooltipLines(this.buildContext((MobEffectInstance)mobEffectInstance), tooltipLines, tooltipFlag);
                return tooltipLines;
            });
        }
        return Optional.empty();
    }

    public MobEffectWidgetContext buildContext(MobEffectInstance mobEffectInstance) {
        return MobEffectWidgetContext.of(mobEffectInstance, this.getEffectRenderer(), this.screenSide);
    }

    public Optional<MobEffectInstance> getHoveredEffect(int mouseX, int mouseY) {
        for (Map.Entry entry : Lists.reverse(this.getEffectPositions(this.activeEffects))) {
            if (!this.isMouseOver(((int[])entry.getValue())[0], ((int[])entry.getValue())[1], mouseX, mouseY)) continue;
            return Optional.of((MobEffectInstance)entry.getKey());
        }
        return Optional.empty();
    }

    private boolean isMouseOver(int posX, int posY, int mouseX, int mouseY) {
        return mouseX >= posX && mouseX <= posX + this.getScaledWidth() && mouseY >= posY && mouseY <= posY + this.getScaledHeight();
    }

    protected List<Component> makeEffectTooltip(MobEffectInstance mobEffectInstance, boolean withDuration) {
        ArrayList tooltip = Lists.newArrayList();
        MutableComponent textComponent = this.getEffectDisplayName(mobEffectInstance);
        if (withDuration && !mobEffectInstance.isInfiniteDuration()) {
            textComponent.append(CommonComponents.SPACE).append((Component)Component.literal((String)"(").append(AbstractEffectRenderer.formatTickDuration(mobEffectInstance.getDuration())).append(")").withStyle(ChatFormatting.GRAY));
        }
        tooltip.add(textComponent);
        String descriptionKey = AbstractEffectRenderer.getDescriptionTranslationKey(mobEffectInstance.getEffect().getDescriptionId());
        if (descriptionKey != null) {
            tooltip.add(Component.translatable((String)descriptionKey).withStyle(ChatFormatting.GRAY));
        }
        return tooltip;
    }

    @Nullable
    private static String getDescriptionTranslationKey(String id) {
        if (Language.getInstance().has(id + ".desc")) {
            return id + ".desc";
        }
        if (Language.getInstance().has(id + ".description")) {
            return id + ".description";
        }
        if (Language.getInstance().has("description." + id)) {
            return "description." + id;
        }
        return null;
    }

    protected MutableComponent getEffectDisplayName(MobEffectInstance mobEffectInstance) {
        MutableComponent textComponent = Component.empty().append(mobEffectInstance.getEffect().getDisplayName());
        String translationKey = "enchantment.level." + (mobEffectInstance.getAmplifier() + 1);
        if (mobEffectInstance.getAmplifier() >= 1 && mobEffectInstance.getAmplifier() <= 9 || Language.getInstance().has(translationKey)) {
            textComponent.append(" ").append((Component)Component.translatable((String)translationKey));
        }
        return textComponent;
    }
}

