/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stylisheffects.client.gui.effects;

import com.google.common.collect.Lists;
import fuzs.stylisheffects.client.gui.effects.CompactEffectRenderer;
import fuzs.stylisheffects.client.handler.EffectRendererEnvironment;
import fuzs.stylisheffects.config.ClientConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import org.apache.commons.lang3.tuple.Pair;

public abstract class GuiEffectRenderer
extends CompactEffectRenderer {
    public GuiEffectRenderer(EffectRendererEnvironment environment) {
        super(environment);
    }

    @Override
    public int getRows() {
        if (this.widgetConfig().separateEffects) {
            int beneficialEffects = this.countBeneficialEffects(this.activeEffects);
            return this.splitByColumns(beneficialEffects) + this.splitByColumns(this.activeEffects.size() - beneficialEffects);
        }
        return super.getRows();
    }

    @Override
    protected int getTopOffset() {
        return 1;
    }

    @Override
    protected int getSpriteOffsetY(boolean withoutDuration) {
        return withoutDuration ? 3 : 2;
    }

    @Override
    protected int getAmplifierOffsetX() {
        return 3;
    }

    @Override
    protected int getAmplifierOffsetY() {
        return 2;
    }

    @Override
    public List<Pair<MobEffectInstance, int[]>> getEffectPositions(List<MobEffectInstance> activeEffects) {
        int beneficialRows = this.splitByColumns(this.countBeneficialEffects(activeEffects));
        int beneficialCounter = 0;
        int harmfulCounter = 0;
        ArrayList effectToPos = Lists.newArrayList();
        for (MobEffectInstance effect : activeEffects) {
            boolean beneficial = !this.widgetConfig().separateEffects || effect.getEffect().isBeneficial();
            int counter = beneficial ? beneficialCounter++ : harmfulCounter++;
            int posX = counter % this.getMaxClampedColumns();
            int posY = counter / this.getMaxClampedColumns();
            if (!beneficial) {
                posY += beneficialRows;
            }
            effectToPos.add(Pair.of((Object)effect, (Object)this.coordsToEffectPosition(posX, posY)));
        }
        if (this.widgetConfig().separateEffects) {
            effectToPos.sort(Comparator.comparing(o -> ((MobEffectInstance)o.getLeft()).getEffect().isBeneficial()).reversed());
        }
        if (beneficialCounter + harmfulCounter != activeEffects.size()) {
            throw new RuntimeException("Effects amount mismatch");
        }
        return effectToPos;
    }

    private int countBeneficialEffects(List<MobEffectInstance> activeEffects) {
        return (int)activeEffects.stream().map(MobEffectInstance::getEffect).filter(MobEffect::isBeneficial).count();
    }

    @Override
    protected abstract ClientConfig.GuiWidgetConfig widgetConfig();
}

