/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.example.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.Creeper;
import software.bernie.example.client.model.entity.ReplacedCreeperModel;
import software.bernie.example.entity.ReplacedCreeperEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoReplacedEntityRenderer;

public class ReplacedCreeperRenderer
extends GeoReplacedEntityRenderer<Creeper, ReplacedCreeperEntity> {
    public ReplacedCreeperRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new ReplacedCreeperModel(), new ReplacedCreeperEntity());
    }

    @Override
    public void preRender(PoseStack poseStack, ReplacedCreeperEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        float swellFactor = ((Creeper)this.currentEntity).getSwelling(partialTick);
        float swellMod = 1.0f + Mth.sin((float)(swellFactor * 100.0f)) * swellFactor * 0.01f;
        swellFactor = (float)Math.pow(Mth.clamp((float)swellFactor, (float)0.0f, (float)1.0f), 3.0);
        float horizontalSwell = (1.0f + swellFactor * 0.4f) * swellMod;
        float verticalSwell = (1.0f + swellFactor * 0.1f) / swellMod;
        poseStack.scale(horizontalSwell, verticalSwell, horizontalSwell);
    }

    @Override
    public int getPackedOverlay(ReplacedCreeperEntity animatable, float u, float partialTick) {
        return super.getPackedOverlay(animatable, this.getSwellOverlay((Creeper)this.currentEntity, u), partialTick);
    }

    protected float getSwellOverlay(Creeper entity, float u) {
        float swell = entity.getSwelling(u);
        return (int)(swell * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)swell, (float)0.5f, (float)1.0f);
    }
}

