/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.example.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BikeEntity
extends Animal
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache(this);

    public BikeEntity(EntityType<? extends Animal> type, Level level) {
        super(type, level);
        this.noCulling = true;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!this.isVehicle()) {
            player.startRiding((Entity)this);
            return super.mobInteract(player, hand);
        }
        return super.mobInteract(player, hand);
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
    }

    public void travel(Vec3 pos) {
        if (this.isAlive() && this.isVehicle()) {
            LivingEntity passenger = this.getControllingPassenger();
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
            this.setYRot(passenger.getYRot());
            this.setXRot(passenger.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yHeadRot = this.yBodyRot = this.getYRot();
            float x = passenger.xxa * 0.5f;
            float z = passenger.zza;
            if (z <= 0.0f) {
                z *= 0.25f;
            }
            this.setSpeed(0.3f);
            super.travel(new Vec3((double)x, pos.y, (double)z));
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity entity;
        Entity entity2 = this.getFirstPassenger();
        return entity2 instanceof LivingEntity ? (entity = (LivingEntity)entity2) : null;
    }

    public boolean isControlledByLocalInstance() {
        return true;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericIdleController(this));
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        return null;
    }
}

