/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.example.entity;

import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DynamicExampleEntity
extends PathfinderMob
implements GeoEntity {
    private static final RawAnimation BLOCK_LEFT = RawAnimation.begin().thenPlay("attack.block.left");
    private static final RawAnimation BLOCK_RIGHT = RawAnimation.begin().thenPlay("attack.block.right");
    private static final RawAnimation AIM_LEFT_HAND = RawAnimation.begin().thenPlay("pose.aim.left");
    private static final RawAnimation AIM_RIGHT_HAND = RawAnimation.begin().thenPlay("pose.aim.right");
    private static final RawAnimation SPEAR_LEFT_HAND = RawAnimation.begin().thenPlay("pose.spear.left");
    private static final RawAnimation SPEAR_RIGHT_HAND = RawAnimation.begin().thenPlay("pose.spear.right");
    private static final RawAnimation INTERACT_LEFT = RawAnimation.begin().thenPlay("misc.interact.right");
    private static final RawAnimation INTERACT_RIGHT = RawAnimation.begin().thenPlay("misc.interact.right");
    private static final RawAnimation SPEAR_SWING = RawAnimation.begin().thenPlay("attack.spear");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache(this);

    public DynamicExampleEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericIdleController(this), new AnimationController<DynamicExampleEntity>(this, "Body", 20, this::poseBody), new AnimationController<DynamicExampleEntity>(this, "Left Hand", 10, state -> this.predicateHandPose(this.getLeftHand(), state)).triggerableAnim("interact", INTERACT_LEFT), new AnimationController<DynamicExampleEntity>(this, "Right Hand", 10, state -> this.predicateHandPose(this.getRightHand(), state)).triggerableAnim("interact", INTERACT_RIGHT), new AnimationController<DynamicExampleEntity>(this, "Dual Wield Pose", 10, this::poseDualWield), new AnimationController<DynamicExampleEntity>(this, "Dual Wield Attack", 10, this::attackDualWield));
    }

    protected PlayState poseBody(AnimationState<DynamicExampleEntity> state) {
        if (this.isWieldingTwoHandedWeapon()) {
            return PlayState.STOP;
        }
        if (this.isPassenger()) {
            state.setAnimation(DefaultAnimations.SIT);
        } else if (this.isCrouching()) {
            state.setAnimation(DefaultAnimations.SNEAK);
        }
        return PlayState.CONTINUE;
    }

    protected PlayState predicateHandPose(InteractionHand hand, AnimationState<DynamicExampleEntity> state) {
        ItemStack heldStack = this.getItemInHand(hand);
        if (heldStack.isEmpty() || this.isWieldingTwoHandedWeapon()) {
            return PlayState.STOP;
        }
        Item handItem = heldStack.getItem();
        if (this.isBlocking() && (handItem instanceof ShieldItem || handItem.getUseAnimation(heldStack) == UseAnim.BLOCK)) {
            return state.setAndContinue(this.getLeftHand() == hand ? BLOCK_LEFT : BLOCK_RIGHT);
        }
        return PlayState.STOP;
    }

    private PlayState poseDualWield(AnimationState<DynamicExampleEntity> state) {
        if (!this.isWieldingTwoHandedWeapon()) {
            return PlayState.STOP;
        }
        for (ItemStack heldStack : this.getHandSlots()) {
            UseAnim useAnim = heldStack.getItem().getUseAnimation(heldStack);
            if (useAnim == UseAnim.BOW || useAnim == UseAnim.CROSSBOW) {
                return state.setAndContinue(this.isLeftHanded() ? AIM_LEFT_HAND : AIM_RIGHT_HAND);
            }
            if (useAnim != UseAnim.SPEAR) continue;
            return state.setAndContinue(this.isLeftHanded() ? SPEAR_LEFT_HAND : SPEAR_RIGHT_HAND);
        }
        return PlayState.STOP;
    }

    private <E extends GeoAnimatable> PlayState attackDualWield(AnimationState<E> state) {
        if (!this.swinging || !this.isWieldingTwoHandedWeapon()) {
            return PlayState.STOP;
        }
        for (ItemStack heldStack : this.getHandSlots()) {
            if (heldStack.getItem().getUseAnimation(heldStack) != UseAnim.SPEAR) continue;
            return state.setAndContinue(SPEAR_SWING);
        }
        return PlayState.STOP;
    }

    public boolean isWieldingTwoHandedWeapon() {
        ItemStack mainHandStack = this.getMainHandItem();
        ItemStack offhandStack = this.getOffhandItem();
        if (mainHandStack.getItem() instanceof ProjectileWeaponItem || offhandStack.getItem() instanceof ProjectileWeaponItem) {
            return true;
        }
        UseAnim anim = mainHandStack.getUseAnimation();
        if (anim == UseAnim.BOW || anim == UseAnim.CROSSBOW || anim == UseAnim.SPEAR) {
            return true;
        }
        anim = offhandStack.getUseAnimation();
        return anim == UseAnim.BOW || anim == UseAnim.CROSSBOW || anim == UseAnim.SPEAR;
    }

    protected InteractionHand getLeftHand() {
        return this.isLeftHanded() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    protected InteractionHand getRightHand() {
        return !this.isLeftHanded() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.level().isClientSide() || stack.isEmpty()) {
            return super.mobInteract(player, hand);
        }
        EquipmentSlot slot = LivingEntity.getEquipmentSlotForItem((ItemStack)stack);
        this.setItemSlot(slot, stack.copy());
        player.sendSystemMessage((Component)Component.translatable((String)"entity.geckolib.mutant_zombie.equip", (Object[])new Object[]{stack.getDisplayName()}));
        if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) {
            this.triggerAnim(this.getLeftHand() == hand ? "Left Hand" : "Right Hand", "interact");
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

