/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.example.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RaceCarEntity
extends Animal
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache(this);

    public RaceCarEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!this.isVehicle()) {
            player.startRiding((Entity)this);
            return super.mobInteract(player, hand);
        }
        return super.mobInteract(player, hand);
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
    }

    public void travel(Vec3 pos) {
        if (this.isAlive() && this.isVehicle()) {
            LivingEntity passenger = this.getControllingPassenger();
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
            this.setYRot(passenger.getYRot());
            this.setXRot(passenger.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yHeadRot = this.yBodyRot = this.getYRot();
            float x = passenger.xxa * 0.5f;
            float z = passenger.zza;
            if (z <= 0.0f) {
                z *= 0.25f;
            }
            this.setSpeed(0.3f);
            super.travel(new Vec3((double)x, pos.y, (double)z));
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity entity;
        Entity entity2 = this.getFirstPassenger();
        return entity2 instanceof LivingEntity ? (entity = (LivingEntity)entity2) : null;
    }

    public boolean isControlledByLocalInstance() {
        return true;
    }

    public void positionRider(Entity entity, Entity.MoveFunction moveFunction) {
        if (entity instanceof LivingEntity) {
            LivingEntity passenger = (LivingEntity)entity;
            moveFunction.accept(entity, this.getX(), this.getY() - (double)0.1f, this.getZ());
            this.xRotO = passenger.xRotO;
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<RaceCarEntity>(this, "controller", 2, state -> {
            if (state.isMoving() && this.getControllingPassenger() != null) {
                return state.setAndContinue(DefaultAnimations.DRIVE);
            }
            return state.setAndContinue(DefaultAnimations.IDLE);
        }).setSoundKeyframeHandler(event -> {}));
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return null;
    }

    protected float getStandingEyeHeight(Pose pose, EntityDimensions dimensions) {
        return 0.5f;
    }
}

