/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable;

import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.network.GeckoLibNetwork;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.network.packet.EntityAnimDataSyncPacket;
import software.bernie.geckolib.network.packet.EntityAnimTriggerPacket;

public interface GeoEntity
extends GeoAnimatable {
    @Nullable
    default public <D> D getAnimData(SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(((Entity)this).getId()).getData(dataTicket);
    }

    default public <D> void setAnimData(SerializableDataTicket<D> dataTicket, D data) {
        Entity entity = (Entity)this;
        if (entity.level().isClientSide()) {
            this.getAnimatableInstanceCache().getManagerForId(entity.getId()).setData(dataTicket, data);
        } else {
            GeckoLibNetwork.send(new EntityAnimDataSyncPacket<D>(entity.getId(), dataTicket, data), PacketDistributor.TRACKING_ENTITY_AND_SELF.with((Object)entity));
        }
    }

    default public void triggerAnim(@Nullable String controllerName, String animName) {
        Entity entity = (Entity)this;
        if (entity.level().isClientSide()) {
            this.getAnimatableInstanceCache().getManagerForId(entity.getId()).tryTriggerAnimation(controllerName, animName);
        } else {
            GeckoLibNetwork.send(new EntityAnimTriggerPacket(entity.getId(), controllerName, animName), PacketDistributor.TRACKING_ENTITY_AND_SELF.with((Object)entity));
        }
    }

    @Override
    default public double getTick(Object entity) {
        return ((Entity)entity).tickCount;
    }
}

