/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import software.bernie.geckolib.GeckoLib;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.network.packet.AnimDataSyncPacket;
import software.bernie.geckolib.network.packet.AnimTriggerPacket;
import software.bernie.geckolib.network.packet.BlockEntityAnimDataSyncPacket;
import software.bernie.geckolib.network.packet.BlockEntityAnimTriggerPacket;
import software.bernie.geckolib.network.packet.EntityAnimDataSyncPacket;
import software.bernie.geckolib.network.packet.EntityAnimTriggerPacket;

public final class GeckoLibNetwork {
    private static final Map<String, GeoAnimatable> SYNCED_ANIMATABLES = new Object2ObjectOpenHashMap();

    public static void init(IEventBus modBus) {
        modBus.addListener(GeckoLibNetwork::registerPackets);
    }

    private static void registerPackets(RegisterPayloadHandlerEvent ev) {
        IPayloadRegistrar registrar = ev.registrar("geckolib");
        registrar.play(AnimDataSyncPacket.ID, AnimDataSyncPacket::decode, AnimDataSyncPacket::receivePacket);
        registrar.play(AnimTriggerPacket.ID, AnimTriggerPacket::decode, AnimTriggerPacket::receivePacket);
        registrar.play(EntityAnimDataSyncPacket.ID, EntityAnimDataSyncPacket::decode, EntityAnimDataSyncPacket::receivePacket);
        registrar.play(EntityAnimTriggerPacket.ID, EntityAnimTriggerPacket::decode, EntityAnimTriggerPacket::receivePacket);
        registrar.play(BlockEntityAnimDataSyncPacket.ID, BlockEntityAnimDataSyncPacket::decode, BlockEntityAnimDataSyncPacket::receivePacket);
        registrar.play(BlockEntityAnimTriggerPacket.ID, BlockEntityAnimTriggerPacket::decode, BlockEntityAnimTriggerPacket::receivePacket);
    }

    public static synchronized void registerSyncedAnimatable(GeoAnimatable animatable) {
        GeoAnimatable existing = SYNCED_ANIMATABLES.put(animatable.getClass().toString(), animatable);
        if (existing == null) {
            GeckoLib.LOGGER.debug("Registered SyncedAnimatable for " + animatable.getClass().toString());
        }
    }

    @Nullable
    public static GeoAnimatable getSyncedAnimatable(String className) {
        GeoAnimatable animatable = SYNCED_ANIMATABLES.get(className);
        if (animatable == null) {
            GeckoLib.LOGGER.error("Attempting to retrieve unregistered synced animatable! (" + className + ")");
        }
        return animatable;
    }

    public static <M> void send(M packet, PacketDistributor.PacketTarget distributor) {
        distributor.send(new CustomPacketPayload[]{(CustomPacketPayload)packet});
    }
}

