/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.network.GeckoLibNetwork;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.util.ClientUtils;

public record AnimDataSyncPacket<D>(String syncableId, long instanceId, SerializableDataTicket<D> dataTicket, D data) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("geckolib", "anim_data_sync");

    public ResourceLocation id() {
        return ID;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.syncableId);
        buffer.writeVarLong(this.instanceId);
        buffer.writeUtf(this.dataTicket.id());
        this.dataTicket.encode(this.data, buffer);
    }

    public static <D> AnimDataSyncPacket<D> decode(FriendlyByteBuf buffer) {
        String syncableId = buffer.readUtf();
        long instanceId = buffer.readVarLong();
        SerializableDataTicket<?> dataTicket = DataTickets.byName(buffer.readUtf());
        Object data = dataTicket.decode(buffer);
        return new AnimDataSyncPacket(syncableId, instanceId, dataTicket, data);
    }

    public void receivePacket(PlayPayloadContext context) {
        context.workHandler().execute(() -> {
            GeoAnimatable animatable = GeckoLibNetwork.getSyncedAnimatable(this.syncableId);
            if (animatable instanceof SingletonGeoAnimatable) {
                SingletonGeoAnimatable singleton = (SingletonGeoAnimatable)animatable;
                singleton.setAnimData((Entity)ClientUtils.getClientPlayer(), this.instanceId, this.dataTicket, this.data);
            }
        });
    }
}

