/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.util.ClientUtils;

public record BlockEntityAnimDataSyncPacket<D>(BlockPos pos, SerializableDataTicket<D> dataTicket, D data) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("geckolib", "block_entity_anim_data_sync");

    public ResourceLocation id() {
        return ID;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeUtf(this.dataTicket.id());
        this.dataTicket.encode(this.data, buffer);
    }

    public static <D> BlockEntityAnimDataSyncPacket<D> decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.readBlockPos();
        SerializableDataTicket<?> dataTicket = DataTickets.byName(buffer.readUtf());
        return new BlockEntityAnimDataSyncPacket(pos, dataTicket, dataTicket.decode(buffer));
    }

    public void receivePacket(PlayPayloadContext context) {
        context.workHandler().execute(() -> {
            BlockEntity blockEntity = ClientUtils.getLevel().getBlockEntity(this.pos);
            if (blockEntity instanceof GeoBlockEntity) {
                GeoBlockEntity geoBlockEntity = (GeoBlockEntity)blockEntity;
                geoBlockEntity.setAnimData(this.dataTicket, this.data);
            }
        });
    }
}

