/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.util.ClientUtils;

public record EntityAnimDataSyncPacket<D>(int entityId, SerializableDataTicket<D> dataTicket, D data) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("geckolib", "entity_anim_data_sync");

    public ResourceLocation id() {
        return ID;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.entityId);
        buffer.writeUtf(this.dataTicket.id());
        this.dataTicket.encode(this.data, buffer);
    }

    public static <D> EntityAnimDataSyncPacket<D> decode(FriendlyByteBuf buffer) {
        int entityId = buffer.readVarInt();
        SerializableDataTicket<?> dataTicket = DataTickets.byName(buffer.readUtf());
        return new EntityAnimDataSyncPacket(entityId, dataTicket, dataTicket.decode(buffer));
    }

    public void receivePacket(PlayPayloadContext context) {
        context.workHandler().execute(() -> {
            Entity entity = ClientUtils.getLevel().getEntity(this.entityId);
            if (entity instanceof GeoEntity) {
                GeoEntity geoEntity = (GeoEntity)entity;
                geoEntity.setAnimData(this.dataTicket, this.data);
            }
        });
    }
}

