/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.GeoReplacedEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.RenderUtils;

public record EntityAnimTriggerPacket<D>(int entityId, boolean isReplacedEntity, @Nullable String controllerName, String animName) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("geckolib", "entity_anim_trigger");

    public EntityAnimTriggerPacket(int entityId, @Nullable String controllerName, String animName) {
        this(entityId, false, controllerName, animName);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.entityId);
        buffer.writeBoolean(this.isReplacedEntity);
        buffer.writeUtf(this.controllerName == null ? "" : this.controllerName);
        buffer.writeUtf(this.animName);
    }

    public static <D> EntityAnimTriggerPacket<D> decode(FriendlyByteBuf buffer) {
        return new EntityAnimTriggerPacket<D>(buffer.readVarInt(), buffer.readBoolean(), buffer.readUtf(), buffer.readUtf());
    }

    public void receivePacket(PlayPayloadContext context) {
        context.workHandler().execute(() -> {
            Entity entity = ClientUtils.getLevel().getEntity(this.entityId);
            if (entity == null) {
                return;
            }
            if (this.isReplacedEntity) {
                GeoAnimatable animatable = RenderUtils.getReplacedAnimatable(entity.getType());
                if (animatable instanceof GeoReplacedEntity) {
                    GeoReplacedEntity replacedEntity = (GeoReplacedEntity)animatable;
                    replacedEntity.triggerAnim(entity, this.controllerName.isEmpty() ? null : this.controllerName, this.animName);
                }
            } else if (entity instanceof GeoEntity) {
                GeoEntity geoEntity = (GeoEntity)entity;
                geoEntity.triggerAnim(this.controllerName.isEmpty() ? null : this.controllerName, this.animName);
            }
        });
    }
}

