/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.texture.AnimatableTexture;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.DataTicket;
import software.bernie.geckolib.event.GeoRenderEvent;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.util.RenderUtils;

public class GeoReplacedEntityRenderer<E extends Entity, T extends GeoAnimatable>
extends EntityRenderer<E>
implements GeoRenderer<T> {
    protected final GeoRenderLayersContainer<T> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected final T animatable;
    protected E currentEntity;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public GeoReplacedEntityRenderer(EntityRendererProvider.Context renderManager, GeoModel<T> model, T animatable) {
        super(renderManager);
        this.model = model;
        this.animatable = animatable;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public T getAnimatable() {
        return this.animatable;
    }

    public E getCurrentEntity() {
        return this.currentEntity;
    }

    @Override
    public long getInstanceId(T animatable) {
        return this.currentEntity.getId();
    }

    @Override
    public ResourceLocation getTextureLocation(E entity) {
        return GeoRenderer.super.getTextureLocation(this.animatable);
    }

    @Override
    public List<GeoRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoReplacedEntityRenderer<E, T> addRenderLayer(GeoRenderLayer<T> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoReplacedEntityRenderer<E, T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoReplacedEntityRenderer<E, T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.entityRenderTranslations = poseStack.last().pose();
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    public void render(E entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        this.currentEntity = entity;
        this.defaultRender(poseStack, (GeoAnimatable)this.animatable, bufferSource, null, null, entityYaw, partialTick, packedLight);
    }

    @Override
    public void actuallyRender(PoseStack poseStack, T animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        boolean isMoving;
        Direction bedDirection;
        Entity entity;
        LivingEntity entity2;
        poseStack.pushPose();
        E e = this.currentEntity;
        LivingEntity livingEntity = e instanceof LivingEntity ? (entity2 = (LivingEntity)e) : null;
        boolean shouldSit = this.currentEntity.isPassenger() && this.currentEntity.getVehicle() != null && this.currentEntity.getVehicle().shouldRiderSit();
        float lerpBodyRot = livingEntity == null ? 0.0f : Mth.rotLerp((float)partialTick, (float)livingEntity.yBodyRotO, (float)livingEntity.yBodyRot);
        float lerpHeadRot = livingEntity == null ? 0.0f : Mth.rotLerp((float)partialTick, (float)livingEntity.yHeadRotO, (float)livingEntity.yHeadRot);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (shouldSit && (entity = this.currentEntity.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            lerpBodyRot = Mth.rotLerp((float)partialTick, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = Mth.clamp((float)Mth.wrapDegrees((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        if (this.currentEntity.getPose() == Pose.SLEEPING && livingEntity != null && (bedDirection = livingEntity.getBedOrientation()) != null) {
            float eyePosOffset = livingEntity.getEyeHeight(Pose.STANDING) - 0.1f;
            poseStack.translate((float)(-bedDirection.getStepX()) * eyePosOffset, 0.0f, (float)(-bedDirection.getStepZ()) * eyePosOffset);
        }
        float ageInTicks = (float)((Entity)this.currentEntity).tickCount + partialTick;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick);
        if (!shouldSit && this.currentEntity.isAlive() && livingEntity != null) {
            limbSwingAmount = livingEntity.walkAnimation.speed(partialTick);
            limbSwing = livingEntity.walkAnimation.position(partialTick);
            if (livingEntity.isBaby()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        float headPitch = Mth.lerp((float)partialTick, (float)((Entity)this.currentEntity).xRotO, (float)this.currentEntity.getXRot());
        float motionThreshold = this.getMotionAnimThreshold((GeoAnimatable)animatable);
        if (livingEntity != null) {
            Vec3 velocity = livingEntity.getDeltaMovement();
            float avgVelocity = (float)(Math.abs(velocity.x) + Math.abs(velocity.z)) / 2.0f;
            isMoving = avgVelocity >= motionThreshold && limbSwingAmount != 0.0f;
        } else {
            boolean bl = isMoving = limbSwingAmount <= -motionThreshold || limbSwingAmount >= motionThreshold;
        }
        if (!isReRender) {
            AnimationState<T> animationState = new AnimationState<T>(animatable, limbSwing, limbSwingAmount, partialTick, isMoving);
            long instanceId = this.getInstanceId(animatable);
            animationState.setData(DataTickets.TICK, animatable.getTick(this.currentEntity));
            animationState.setData(DataTickets.ENTITY, this.currentEntity);
            animationState.setData(DataTickets.ENTITY_MODEL_DATA, new EntityModelData(shouldSit, livingEntity != null && livingEntity.isBaby(), -netHeadYaw, -headPitch));
            this.model.addAdditionalStateData((GeoAnimatable)animatable, instanceId, (BiConsumer<DataTicket<GeoAnimatable>, GeoAnimatable>)((BiConsumer<DataTicket, GeoAnimatable>)animationState::setData));
            this.model.handleAnimations(animatable, instanceId, animationState);
        }
        poseStack.translate(0.0f, 0.01f, 0.0f);
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
        if (this.currentEntity.isInvisibleTo((Player)Minecraft.getInstance().player)) {
            if (Minecraft.getInstance().shouldEntityAppearGlowing(this.currentEntity)) {
                renderType = RenderType.outline((ResourceLocation)this.getTextureLocation((E)animatable));
                buffer = bufferSource.getBuffer(renderType);
            } else {
                renderType = null;
            }
        }
        if (renderType != null) {
            GeoRenderer.super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        }
        poseStack.popPose();
    }

    @Override
    public void applyRenderLayers(PoseStack poseStack, T animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (!this.currentEntity.isSpectator()) {
            GeoRenderer.super.applyRenderLayers(poseStack, animatable, model, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
    }

    @Override
    public void renderFinal(PoseStack poseStack, T animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Mob mob;
        Entity leashHolder;
        super.render(this.currentEntity, 0.0f, partialTick, poseStack, bufferSource, packedLight);
        E e = this.currentEntity;
        if (e instanceof Mob && (leashHolder = (mob = (Mob)e).getLeashHolder()) != null) {
            this.renderLeash(mob, partialTick, poseStack, bufferSource, leashHolder);
        }
    }

    @Override
    public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.pushPose();
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, this.getRenderOffset((Entity)this.currentEntity, 1.0f).toVector3f()));
            bone.setWorldSpaceMatrix(RenderUtils.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), this.currentEntity.position().toVector3f()));
        }
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        if (!isReRender) {
            this.applyRenderLayersForBone(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
        this.renderChildBones(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.popPose();
    }

    protected void applyRotations(T animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        LivingEntity entity;
        LivingEntity livingEntity;
        Pose pose = this.currentEntity.getPose();
        E e = this.currentEntity;
        LivingEntity livingEntity2 = livingEntity = e instanceof LivingEntity ? (entity = (LivingEntity)e) : null;
        if (this.isShaking(animatable)) {
            rotationYaw += (float)(Math.cos((double)((Entity)this.currentEntity).tickCount * 3.25) * Math.PI * 0.4);
        }
        if (pose != Pose.SLEEPING) {
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - rotationYaw));
        }
        if (livingEntity != null && livingEntity.deathTime > 0) {
            float deathRotation = ((float)livingEntity.deathTime + partialTick - 1.0f) / 20.0f * 1.6f;
            poseStack.mulPose(Axis.ZP.rotationDegrees(Math.min(Mth.sqrt((float)deathRotation), 1.0f) * this.getDeathMaxRotation(animatable)));
        } else if (livingEntity != null && livingEntity.isAutoSpinAttack()) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f - livingEntity.getXRot()));
            poseStack.mulPose(Axis.YP.rotationDegrees(((float)livingEntity.tickCount + partialTick) * -75.0f));
        } else if (livingEntity != null && pose == Pose.SLEEPING) {
            Direction bedOrientation = livingEntity.getBedOrientation();
            poseStack.mulPose(Axis.YP.rotationDegrees(bedOrientation != null ? RenderUtils.getDirectionAngle(bedOrientation) : rotationYaw));
            poseStack.mulPose(Axis.ZP.rotationDegrees(this.getDeathMaxRotation(animatable)));
            poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
        } else if (this.currentEntity.hasCustomName() || this.currentEntity instanceof Player) {
            String name = this.currentEntity.getName().getString();
            E e2 = this.currentEntity;
            if (e2 instanceof Player) {
                Player player = (Player)e2;
                if (!player.isModelPartShown(PlayerModelPart.CAPE)) {
                    return;
                }
            } else {
                name = ChatFormatting.stripFormatting((String)name);
            }
            if (name != null && (name.equals("Dinnerbone") || name.equalsIgnoreCase("Grumm"))) {
                poseStack.translate(0.0f, this.currentEntity.getBbHeight() + 0.1f, 0.0f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            }
        }
    }

    protected float getDeathMaxRotation(T animatable) {
        return 90.0f;
    }

    public double getNameRenderCutoffDistance(E entity, T animatable) {
        return entity.isDiscrete() ? 32.0 : 64.0;
    }

    public boolean shouldShowName(E entity) {
        if (!(entity instanceof LivingEntity)) {
            return super.shouldShowName(entity);
        }
        double nameRenderCutoff = this.getNameRenderCutoffDistance(entity, this.animatable);
        if (this.entityRenderDispatcher.distanceToSqr(entity) >= nameRenderCutoff * nameRenderCutoff) {
            return false;
        }
        if (!(!(entity instanceof Mob) || entity.shouldShowName() || entity.hasCustomName() && entity == this.entityRenderDispatcher.crosshairPickEntity)) {
            return false;
        }
        Minecraft minecraft = Minecraft.getInstance();
        boolean visibleToClient = !entity.isInvisibleTo((Player)minecraft.player);
        PlayerTeam entityTeam = entity.getTeam();
        if (entityTeam == null) {
            return Minecraft.renderNames() && entity != minecraft.getCameraEntity() && visibleToClient && !entity.isVehicle();
        }
        PlayerTeam playerTeam = minecraft.player.getTeam();
        return switch (entityTeam.getNameTagVisibility()) {
            default -> throw new IncompatibleClassChangeError();
            case Team.Visibility.ALWAYS -> visibleToClient;
            case Team.Visibility.NEVER -> false;
            case Team.Visibility.HIDE_FOR_OTHER_TEAMS -> {
                if (playerTeam == null) {
                    yield visibleToClient;
                }
                if (entityTeam.isAlliedTo((Team)playerTeam) && (entityTeam.canSeeFriendlyInvisibles() || visibleToClient)) {
                    yield true;
                }
                yield false;
            }
            case Team.Visibility.HIDE_FOR_OWN_TEAM -> playerTeam == null ? visibleToClient : !entityTeam.isAlliedTo((Team)playerTeam) && visibleToClient;
        };
    }

    @Override
    public int getPackedOverlay(T animatable, float u) {
        E e = this.currentEntity;
        if (!(e instanceof LivingEntity)) {
            return OverlayTexture.NO_OVERLAY;
        }
        LivingEntity entity = (LivingEntity)e;
        return OverlayTexture.pack((int)OverlayTexture.u((float)u), (int)OverlayTexture.v((entity.hurtTime > 0 || entity.deathTime > 0 ? 1 : 0) != 0));
    }

    @Override
    public int getPackedOverlay(T animatable, float u, float partialTick) {
        return this.getPackedOverlay(animatable, u);
    }

    public boolean isShaking(T animatable) {
        return this.currentEntity.isFullyFrozen();
    }

    public <H extends Entity, M extends Mob> void renderLeash(M mob, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, H leashHolder) {
        int segment;
        double lerpBodyAngle = Mth.lerp((float)partialTick, (float)mob.yBodyRotO, (float)mob.yBodyRot) * ((float)Math.PI / 180) + 1.5707964f;
        Vec3 leashOffset = mob.getLeashOffset();
        double xAngleOffset = Math.cos(lerpBodyAngle) * leashOffset.z + Math.sin(lerpBodyAngle) * leashOffset.x;
        double zAngleOffset = Math.sin(lerpBodyAngle) * leashOffset.z - Math.cos(lerpBodyAngle) * leashOffset.x;
        double lerpOriginX = Mth.lerp((double)partialTick, (double)mob.xo, (double)mob.getX()) + xAngleOffset;
        double lerpOriginY = Mth.lerp((double)partialTick, (double)mob.yo, (double)mob.getY()) + leashOffset.y;
        double lerpOriginZ = Mth.lerp((double)partialTick, (double)mob.zo, (double)mob.getZ()) + zAngleOffset;
        Vec3 ropeGripPosition = leashHolder.getRopeHoldPosition(partialTick);
        float xDif = (float)(ropeGripPosition.x - lerpOriginX);
        float yDif = (float)(ropeGripPosition.y - lerpOriginY);
        float zDif = (float)(ropeGripPosition.z - lerpOriginZ);
        float offsetMod = Mth.invSqrt((float)(xDif * xDif + zDif * zDif)) * 0.025f / 2.0f;
        float xOffset = zDif * offsetMod;
        float zOffset = xDif * offsetMod;
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.leash());
        BlockPos entityEyePos = BlockPos.containing((Position)mob.getEyePosition(partialTick));
        BlockPos holderEyePos = BlockPos.containing((Position)leashHolder.getEyePosition(partialTick));
        int entityBlockLight = this.getBlockLightLevel((Entity)mob, entityEyePos);
        int holderBlockLight = leashHolder.isOnFire() ? 15 : leashHolder.level().getBrightness(LightLayer.BLOCK, holderEyePos);
        int entitySkyLight = mob.level().getBrightness(LightLayer.SKY, entityEyePos);
        int holderSkyLight = mob.level().getBrightness(LightLayer.SKY, holderEyePos);
        poseStack.pushPose();
        poseStack.translate(xAngleOffset, leashOffset.y, zAngleOffset);
        Matrix4f posMatrix = new Matrix4f((Matrix4fc)poseStack.last().pose());
        for (segment = 0; segment <= 24; ++segment) {
            GeoReplacedEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.025f, xOffset, zOffset, segment, false);
        }
        for (segment = 24; segment >= 0; --segment) {
            GeoReplacedEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.0f, xOffset, zOffset, segment, true);
        }
        poseStack.popPose();
    }

    private static void renderLeashPiece(VertexConsumer buffer, Matrix4f positionMatrix, float xDif, float yDif, float zDif, int entityBlockLight, int holderBlockLight, int entitySkyLight, int holderSkyLight, float width, float yOffset, float xOffset, float zOffset, int segment, boolean isLeashKnot) {
        float piecePosPercent = (float)segment / 24.0f;
        int lerpBlockLight = (int)Mth.lerp((float)piecePosPercent, (float)entityBlockLight, (float)holderBlockLight);
        int lerpSkyLight = (int)Mth.lerp((float)piecePosPercent, (float)entitySkyLight, (float)holderSkyLight);
        int packedLight = LightTexture.pack((int)lerpBlockLight, (int)lerpSkyLight);
        float knotColourMod = segment % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * knotColourMod;
        float green = 0.4f * knotColourMod;
        float blue = 0.3f * knotColourMod;
        float x = xDif * piecePosPercent;
        float y = yDif > 0.0f ? yDif * piecePosPercent * piecePosPercent : yDif - yDif * (1.0f - piecePosPercent) * (1.0f - piecePosPercent);
        float z = zDif * piecePosPercent;
        buffer.vertex(positionMatrix, x - xOffset, y + yOffset, z + zOffset).color(red, green, blue, 1.0f).uv2(packedLight).endVertex();
        buffer.vertex(positionMatrix, x + xOffset, y + width - yOffset, z - zOffset).color(red, green, blue, 1.0f).uv2(packedLight).endVertex();
    }

    @Override
    public void updateAnimatedTextureFrame(T animatable) {
        AnimatableTexture.setAndUpdate(this.getTextureLocation((E)animatable));
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        NeoForge.EVENT_BUS.post((Event)new GeoRenderEvent.ReplacedEntity.CompileRenderLayers(this));
    }

    @Override
    public boolean firePreRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
        return !((GeoRenderEvent.ReplacedEntity.Pre)NeoForge.EVENT_BUS.post((Event)new GeoRenderEvent.ReplacedEntity.Pre(this, poseStack, model, bufferSource, partialTick, packedLight))).isCanceled();
    }

    @Override
    public void firePostRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
        NeoForge.EVENT_BUS.post((Event)new GeoRenderEvent.ReplacedEntity.Post(this, poseStack, model, bufferSource, partialTick, packedLight));
    }
}

