/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterfortresses.util;

import com.google.common.collect.ImmutableList;
import com.yungnickyoung.minecraft.betterfortresses.mixin.accessor.StructureManagerAccessor;
import com.yungnickyoung.minecraft.betterfortresses.mixin.accessor.WorldGenRegionAccessor;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class MixinUtil {
    public static StructureStart getStructureAt(StructureManager structureManager, BlockPos pos, Structure structure) {
        for (StructureStart structurestart : MixinUtil.startsForStructure(structureManager, SectionPos.of((BlockPos)pos), structure)) {
            if (!structurestart.getBoundingBox().isInside((Vec3i)pos)) continue;
            return structurestart;
        }
        return StructureStart.INVALID_START;
    }

    private static List<StructureStart> startsForStructure(StructureManager structureManager, SectionPos sectionPos, Structure structure) {
        LongSet longset = ((StructureManagerAccessor)structureManager).getLevel().getChunk(sectionPos.x(), sectionPos.z(), ChunkStatus.STRUCTURE_REFERENCES).getReferencesForStructure(structure);
        ImmutableList.Builder builder = ImmutableList.builder();
        MixinUtil.fillStartsForStructure(structureManager, structure, longset, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    private static void fillStartsForStructure(StructureManager structureManager, Structure structure, LongSet longSet, Consumer<StructureStart> consumer) {
        LongIterator longIterator = longSet.iterator();
        while (longIterator.hasNext()) {
            StructureStart structurestart;
            long i = (Long)longIterator.next();
            SectionPos sectionpos = SectionPos.of((ChunkPos)new ChunkPos(i), (int)((StructureManagerAccessor)structureManager).getLevel().getMinSection());
            Optional<ChunkAccess> structureAccess = MixinUtil.getChunk((WorldGenRegion)((StructureManagerAccessor)structureManager).getLevel(), sectionpos.x(), sectionpos.z());
            if (!structureAccess.isPresent() || (structurestart = structureManager.getStartForStructure(sectionpos, structure, (StructureAccess)structureAccess.get())) == null || !structurestart.isValid()) continue;
            consumer.accept(structurestart);
        }
    }

    private static Optional<ChunkAccess> getChunk(WorldGenRegion worldGenRegion, int chunkX, int chunkZ) {
        WorldGenRegionAccessor accessor = (WorldGenRegionAccessor)worldGenRegion;
        if (worldGenRegion.hasChunk(chunkX, chunkZ)) {
            int i = chunkX - accessor.getFirstPos().x;
            int j = chunkZ - accessor.getFirstPos().z;
            ChunkAccess chunkAccess = accessor.getCache().get(i + j * accessor.getSize());
            if (chunkAccess.getStatus().isOrAfter(ChunkStatus.STRUCTURE_STARTS)) {
                return Optional.of(chunkAccess);
            }
        }
        return Optional.empty();
    }
}

