/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterfortresses.world.processor;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterfortresses.module.StructureProcessorTypeModule;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BridgeArchProcessor
extends StructureProcessor {
    public static final BridgeArchProcessor INSTANCE = new BridgeArchProcessor();
    public static final Codec<BridgeArchProcessor> CODEC = Codec.unit(() -> INSTANCE);

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.state().is(Blocks.PRISMARINE_STAIRS) || blockInfoGlobal.state().is(Blocks.PRISMARINE_BRICK_STAIRS)) {
            Direction facing = structurePlacementData.getRotation().rotate((Direction)blockInfoGlobal.state().getValue((Property)StairBlock.FACING));
            boolean isJunction = blockInfoGlobal.state().is(Blocks.PRISMARINE_STAIRS);
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), Blocks.NETHER_BRICKS.defaultBlockState(), null);
            if (!(levelReader instanceof WorldGenRegion)) {
                return blockInfoGlobal;
            }
            WorldGenRegion worldGenRegion = (WorldGenRegion)levelReader;
            if (levelReader.getChunk(blockInfoGlobal.pos().above(3)).getBlockState(blockInfoGlobal.pos().above(3)).isAir()) {
                return blockInfoGlobal;
            }
            BlockPos.MutableBlockPos mutable = blockInfoGlobal.pos().mutable();
            mutable.move(Direction.UP);
            this.placeBlock(worldGenRegion, levelReader, (BlockPos)mutable, Blocks.NETHER_BRICKS.defaultBlockState());
            mutable.move(Direction.UP);
            this.placeWallBlock(worldGenRegion, levelReader, (BlockPos)mutable, (BlockState)((BlockState)((BlockState)((BlockState)Blocks.NETHER_BRICK_WALL.defaultBlockState().setValue((Property)WallBlock.EAST_WALL, (Comparable)(facing == Direction.EAST || isJunction && facing == Direction.NORTH ? WallSide.LOW : WallSide.NONE))).setValue((Property)WallBlock.SOUTH_WALL, (Comparable)(facing == Direction.SOUTH || isJunction && facing == Direction.EAST ? WallSide.LOW : WallSide.NONE))).setValue((Property)WallBlock.WEST_WALL, (Comparable)(facing == Direction.WEST || isJunction && facing == Direction.SOUTH ? WallSide.LOW : WallSide.NONE))).setValue((Property)WallBlock.NORTH_WALL, (Comparable)(facing == Direction.NORTH || isJunction && facing == Direction.WEST ? WallSide.LOW : WallSide.NONE)));
            mutable.move(facing);
            this.placeBlock(worldGenRegion, levelReader, (BlockPos)mutable, (BlockState)((BlockState)Blocks.NETHER_BRICK_STAIRS.defaultBlockState().setValue((Property)StairBlock.HALF, (Comparable)Half.TOP)).setValue((Property)StairBlock.FACING, (Comparable)facing.getOpposite()));
            mutable.move(Direction.UP);
            this.placeWallBlock(worldGenRegion, levelReader, (BlockPos)mutable, (BlockState)((BlockState)((BlockState)((BlockState)Blocks.NETHER_BRICK_WALL.defaultBlockState().setValue((Property)WallBlock.EAST_WALL, (Comparable)(facing == Direction.EAST ? WallSide.LOW : WallSide.NONE))).setValue((Property)WallBlock.SOUTH_WALL, (Comparable)(facing == Direction.SOUTH ? WallSide.LOW : WallSide.NONE))).setValue((Property)WallBlock.WEST_WALL, (Comparable)(facing == Direction.WEST ? WallSide.LOW : WallSide.NONE))).setValue((Property)WallBlock.NORTH_WALL, (Comparable)(facing == Direction.NORTH ? WallSide.LOW : WallSide.NONE)));
            mutable.move(facing);
            this.placeBlock(worldGenRegion, levelReader, (BlockPos)mutable, Blocks.NETHER_BRICKS.defaultBlockState());
            mutable.move(Direction.UP);
            this.placeWallBlock(worldGenRegion, levelReader, (BlockPos)mutable, Blocks.NETHER_BRICK_WALL.defaultBlockState());
            mutable.move(facing);
            mutable.move(Direction.DOWN);
            this.placeWallBlock(worldGenRegion, levelReader, (BlockPos)mutable, (BlockState)((BlockState)((BlockState)((BlockState)Blocks.NETHER_BRICK_WALL.defaultBlockState().setValue((Property)WallBlock.EAST_WALL, (Comparable)(facing == Direction.WEST ? WallSide.LOW : WallSide.NONE))).setValue((Property)WallBlock.SOUTH_WALL, (Comparable)(facing == Direction.NORTH ? WallSide.LOW : WallSide.NONE))).setValue((Property)WallBlock.WEST_WALL, (Comparable)(facing == Direction.EAST ? WallSide.LOW : WallSide.NONE))).setValue((Property)WallBlock.NORTH_WALL, (Comparable)(facing == Direction.SOUTH ? WallSide.LOW : WallSide.NONE)));
            mutable.move(Direction.DOWN);
            this.placeBlock(worldGenRegion, levelReader, (BlockPos)mutable, (BlockState)((BlockState)Blocks.NETHER_BRICK_STAIRS.defaultBlockState().setValue((Property)StairBlock.HALF, (Comparable)Half.TOP)).setValue((Property)StairBlock.FACING, (Comparable)facing));
            mutable.move(facing);
            this.placeWallBlock(worldGenRegion, levelReader, (BlockPos)mutable, (BlockState)((BlockState)((BlockState)((BlockState)Blocks.NETHER_BRICK_WALL.defaultBlockState().setValue((Property)WallBlock.EAST_WALL, (Comparable)(facing == Direction.WEST || isJunction && facing == Direction.NORTH ? WallSide.LOW : WallSide.NONE))).setValue((Property)WallBlock.SOUTH_WALL, (Comparable)(facing == Direction.NORTH || isJunction && facing == Direction.EAST ? WallSide.LOW : WallSide.NONE))).setValue((Property)WallBlock.WEST_WALL, (Comparable)(facing == Direction.EAST || isJunction && facing == Direction.SOUTH ? WallSide.LOW : WallSide.NONE))).setValue((Property)WallBlock.NORTH_WALL, (Comparable)(facing == Direction.SOUTH || isJunction && facing == Direction.WEST ? WallSide.LOW : WallSide.NONE)));
            mutable.move(Direction.DOWN);
            this.placeBlock(worldGenRegion, levelReader, (BlockPos)mutable, Blocks.NETHER_BRICKS.defaultBlockState());
            mutable.move(Direction.DOWN);
            this.placeBlock(worldGenRegion, levelReader, (BlockPos)mutable, Blocks.NETHER_BRICKS.defaultBlockState());
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorTypeModule.BRIDGE_ARCH_PROCESSOR;
    }

    private void placeBlock(WorldGenRegion worldGenRegion, LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        if (worldGenRegion.getCenter().equals((Object)new ChunkPos(blockPos))) {
            levelReader.getChunk(blockPos).setBlockState(blockPos, blockState, false);
        }
    }

    private void placeWallBlock(WorldGenRegion worldGenRegion, LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        if (worldGenRegion.getCenter().equals((Object)new ChunkPos(blockPos))) {
            BlockPos.MutableBlockPos mutable = blockPos.mutable();
            mutable.move(Direction.NORTH);
            boolean north = levelReader.getChunk((BlockPos)mutable).getBlockState((BlockPos)mutable).isFaceSturdy((BlockGetter)levelReader, (BlockPos)mutable, Direction.SOUTH);
            mutable.set((Vec3i)blockPos).move(Direction.EAST);
            boolean east = levelReader.getChunk((BlockPos)mutable).getBlockState((BlockPos)mutable).isFaceSturdy((BlockGetter)levelReader, (BlockPos)mutable, Direction.WEST);
            mutable.set((Vec3i)blockPos).move(Direction.SOUTH);
            boolean south = levelReader.getChunk((BlockPos)mutable).getBlockState((BlockPos)mutable).isFaceSturdy((BlockGetter)levelReader, (BlockPos)mutable, Direction.NORTH);
            mutable.set((Vec3i)blockPos).move(Direction.WEST);
            boolean west = levelReader.getChunk((BlockPos)mutable).getBlockState((BlockPos)mutable).isFaceSturdy((BlockGetter)levelReader, (BlockPos)mutable, Direction.EAST);
            levelReader.getChunk(blockPos).setBlockState(blockPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue((Property)WallBlock.NORTH_WALL, (Comparable)(north ? WallSide.LOW : (WallSide)blockState.getValue((Property)WallBlock.NORTH_WALL)))).setValue((Property)WallBlock.EAST_WALL, (Comparable)(east ? WallSide.LOW : (WallSide)blockState.getValue((Property)WallBlock.EAST_WALL)))).setValue((Property)WallBlock.SOUTH_WALL, (Comparable)(south ? WallSide.LOW : (WallSide)blockState.getValue((Property)WallBlock.SOUTH_WALL)))).setValue((Property)WallBlock.WEST_WALL, (Comparable)(west ? WallSide.LOW : (WallSide)blockState.getValue((Property)WallBlock.WEST_WALL)))).setValue((Property)WallBlock.UP, (Comparable)Boolean.valueOf(true)), false);
        }
    }
}

